/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.base;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import org.gmwframework.cloud.common.base.CommonCode;
import org.gmwframework.cloud.common.base.IResultCode;
import org.gmwframework.cloud.common.base.ResultTypeEnum;
import org.gmwframework.cloud.common.utils.StrUtils;

public class ApiResult<T>
implements Serializable {
    private static final long serialVersionUID = -6109881088423213930L;
    @ApiModelProperty(value="\u6210\u529f200\uff0c\u5f02\u5e38500\uff0c\u9519\u8bef501\uff0c\u5931\u8d25502")
    private int code;
    private String errorCode;
    private String errMsg;
    private T data;
    private boolean success;
    private String xTraceId;

    public static <T> ApiResult<T> success(T data) {
        return ApiResult.write(ResultTypeEnum.SUCCESS, CommonCode.OK, null, data);
    }

    public static <T> ApiResult<T> success(T data, String xTraceId) {
        ApiResult<T> apiResult = ApiResult.write(ResultTypeEnum.SUCCESS, CommonCode.OK, null, data);
        apiResult.setXTraceId(xTraceId);
        return apiResult;
    }

    public static <T> ApiResult<T> success() {
        return ApiResult.write(ResultTypeEnum.SUCCESS, CommonCode.OK, null, null);
    }

    public static <T> ApiResult<T> exception(IResultCode resultCode) {
        return ApiResult.exception(resultCode, null);
    }

    public static <T> ApiResult<T> exception(IResultCode resultCode, String msg) {
        return ApiResult.write(ResultTypeEnum.EXCEPTION, resultCode, msg, null);
    }

    public static <T> ApiResult<T> error(IResultCode resultCode) {
        return ApiResult.error(resultCode, null);
    }

    public static <T> ApiResult<T> error(IResultCode resultCode, String msg) {
        return ApiResult.write(ResultTypeEnum.ERROR, resultCode, msg, null);
    }

    public static <T> ApiResult<T> error(IResultCode resultCode, String msg, String xTraceId) {
        ApiResult<Object> apiResult = ApiResult.write(ResultTypeEnum.ERROR, resultCode, msg, null);
        apiResult.setXTraceId(xTraceId);
        return apiResult;
    }

    private static <T> ApiResult<T> write(ResultTypeEnum typeEnum, IResultCode resultCode, String msg, T data) {
        ApiResult<T> apiResult = new ApiResult<T>();
        apiResult.setCode(typeEnum.getCode());
        if (resultCode != null) {
            apiResult.setErrorCode(resultCode.getCode());
            apiResult.setErrMsg(StrUtils.isEmpty(msg) ? resultCode.getMsg() : msg);
        } else {
            apiResult.setErrMsg(StrUtils.isEmpty(msg) ? typeEnum.getDesc() : msg);
        }
        apiResult.setData(data);
        return apiResult;
    }

    public boolean isSuccess() {
        return this.code == ResultTypeEnum.SUCCESS.getCode();
    }

    public int getCode() {
        return this.code;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public T getData() {
        return this.data;
    }

    public String getXTraceId() {
        return this.xTraceId;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setXTraceId(String xTraceId) {
        this.xTraceId = xTraceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ApiResult)) {
            return false;
        }
        ApiResult other = (ApiResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        String this$errorCode = this.getErrorCode();
        String other$errorCode = other.getErrorCode();
        if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) {
            return false;
        }
        String this$errMsg = this.getErrMsg();
        String other$errMsg = other.getErrMsg();
        if (this$errMsg == null ? other$errMsg != null : !this$errMsg.equals(other$errMsg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$xTraceId = this.getXTraceId();
        String other$xTraceId = other.getXTraceId();
        return !(this$xTraceId == null ? other$xTraceId != null : !this$xTraceId.equals(other$xTraceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ApiResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        String $errorCode = this.getErrorCode();
        result = result * 59 + ($errorCode == null ? 43 : $errorCode.hashCode());
        String $errMsg = this.getErrMsg();
        result = result * 59 + ($errMsg == null ? 43 : $errMsg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $xTraceId = this.getXTraceId();
        result = result * 59 + ($xTraceId == null ? 43 : $xTraceId.hashCode());
        return result;
    }

    public String toString() {
        return "ApiResult(code=" + this.getCode() + ", errorCode=" + this.getErrorCode() + ", errMsg=" + this.getErrMsg() + ", data=" + this.getData() + ", success=" + this.isSuccess() + ", xTraceId=" + this.getXTraceId() + ")";
    }
}

