/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.enunfield;

import org.apache.commons.lang3.StringUtils;
import org.gmwframework.cloud.common.annotation.EnumField;
import org.gmwframework.cloud.common.base.ICommonEnum;

public class EnumFieldUtils {
    private static String getEnumValue(String enumName, String enumValue) throws ClassNotFoundException {
        Class<?> cls = Class.forName(enumName);
        Enum[] objs = (Enum[])cls.getEnumConstants();
        for (int i = 0; i < objs.length; ++i) {
            ICommonEnum baseEnum = (ICommonEnum)((Object)objs[i]);
            if (!String.valueOf(baseEnum.getCode().toString()).equals(enumValue)) continue;
            return baseEnum.getDesc().toString();
        }
        return null;
    }

    public static String getEnumValue(EnumField enumField, String enumValue) throws ClassNotFoundException {
        String messageSourceKey = EnumFieldUtils.getEnumValue(enumField.value(), enumValue);
        String defaultValue = enumField.defaultValue();
        return StringUtils.isNotBlank((CharSequence)messageSourceKey) ? messageSourceKey : defaultValue;
    }
}

