/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.utils;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.helpers.MessageFormatter;

public class StrUtils
extends StringUtils {
    private static final String NULLSTR = "";
    private static final char SEPARATOR = '_';
    private static final String START = "*";

    public static <T> T nvl(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean isEmpty(Collection<?> coll) {
        return StrUtils.isNull(coll) || coll.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> coll) {
        return !StrUtils.isEmpty(coll);
    }

    public static boolean isEmpty(Object[] objects) {
        return StrUtils.isNull(objects) || objects.length == 0;
    }

    public static boolean isNotEmpty(Object[] objects) {
        return !StrUtils.isEmpty(objects);
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return StrUtils.isNull(map) || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !StrUtils.isEmpty(map);
    }

    public static boolean isEmpty(String str) {
        return StrUtils.isNull(str) || NULLSTR.equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !StrUtils.isEmpty(str);
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static boolean isCollectNull(Collection<?> collection) {
        return StrUtils.isNull(collection) || collection.size() == 0;
    }

    public static boolean isCollectNotNull(Collection<?> collection) {
        return !StrUtils.isCollectNull(collection);
    }

    public static boolean isNotNull(Object object) {
        return !StrUtils.isNull(object);
    }

    public static boolean matches(String str, List<String> strs) {
        if (StrUtils.isEmpty(str) || StrUtils.isEmpty(strs)) {
            return false;
        }
        for (String testStr : strs) {
            if (!StrUtils.matches(str, testStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(String str, String ... strs) {
        if (StrUtils.isEmpty(str) || StrUtils.isEmpty(strs)) {
            return false;
        }
        for (String testStr : strs) {
            if (!StrUtils.matches(str, testStr)) continue;
            return true;
        }
        return false;
    }

    public static boolean matches(String str, String pattern) {
        if (StrUtils.isEmpty(pattern) || StrUtils.isEmpty(str)) {
            return false;
        }
        if (str.equals(pattern)) {
            return true;
        }
        int beginOffset = 0;
        int formerStarOffset = -1;
        int latterStarOffset = -1;
        String remainingURI = str;
        String prefixPattern = NULLSTR;
        String suffixPattern = NULLSTR;
        boolean result = false;
        do {
            prefixPattern = StrUtils.substring((String)pattern, (int)beginOffset, (int)((formerStarOffset = StrUtils.indexOf((CharSequence)pattern, (CharSequence)START, (int)beginOffset)) > -1 ? formerStarOffset : pattern.length()));
            result = remainingURI.contains(prefixPattern);
            if (formerStarOffset == -1) {
                return result;
            }
            if (!result) {
                return false;
            }
            if (!StrUtils.isEmpty(prefixPattern)) {
                remainingURI = StrUtils.substringAfter((String)str, (String)prefixPattern);
            }
            if (!(result = remainingURI.contains(suffixPattern = StrUtils.substring((String)pattern, (int)(formerStarOffset + 1), (int)((latterStarOffset = StrUtils.indexOf((CharSequence)pattern, (CharSequence)START, (int)(formerStarOffset + 1))) > -1 ? latterStarOffset : pattern.length()))))) {
                return false;
            }
            if (!StrUtils.isEmpty(suffixPattern)) {
                remainingURI = StrUtils.substringAfter((String)str, (String)suffixPattern);
            }
            beginOffset = latterStarOffset + 1;
        } while (!StrUtils.isEmpty(suffixPattern) && !StrUtils.isEmpty(remainingURI));
        return true;
    }

    public static String getDurationBySeconds(long seconds) {
        if (seconds < 60L) {
            return seconds + "\u79d2";
        }
        if (seconds < 3600L) {
            return seconds / 60L + "\u5206" + seconds % 60L + "\u79d2";
        }
        if (seconds < 86400L) {
            return seconds / 60L / 60L + "\u5c0f\u65f6" + seconds / 60L % 60L + "\u5206" + seconds % 60L + "\u79d2";
        }
        return seconds / 60L / 60L / 24L + "\u5929" + seconds / 60L / 60L % 24L + "\u5c0f\u65f6" + seconds / 60L % 60L + "\u5206" + seconds % 60L + "\u79d2";
    }

    public static String format(String appendPattern, Object ... appendArguments) {
        return MessageFormatter.arrayFormat((String)appendPattern, (Object[])appendArguments).getMessage();
    }
}

