/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.I18n;

import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class I18nUtil {
    private static MessageSource messageSource;

    public I18nUtil(MessageSource messageSource) {
        I18nUtil.messageSource = messageSource;
    }

    public static String get(String key) {
        try {
            if (StringUtils.isNotBlank((CharSequence)key)) {
                key = key.replace("$", "").replace("{", "").replace("}", "");
            }
            return messageSource.getMessage(key, null, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            return key;
        }
    }

    public static String get(String key, Object arg) {
        try {
            if (StringUtils.isNotBlank((CharSequence)key)) {
                key = key.replace("$", "").replace("{", "").replace("}", "");
            }
            return messageSource.getMessage(key, new Object[]{arg}, LocaleContextHolder.getLocale());
        }
        catch (Exception e) {
            return arg != null ? arg.toString() : key;
        }
    }
}

