/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.I18n;

import java.text.NumberFormat;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.gmwframework.cloud.common.I18n.MessageSourceUtils;
import org.gmwframework.cloud.common.annotation.LocalizedField;
import org.gmwframework.cloud.common.base.ICommonEnum;
import org.springframework.context.MessageSource;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class LocalizedUtils {
    private static String getMessageSourceKey(String localizedValue, String enumValue) throws ClassNotFoundException {
        Class<?> cls = Class.forName(localizedValue);
        Enum[] objs = (Enum[])cls.getEnumConstants();
        for (int i = 0; i < objs.length; ++i) {
            ICommonEnum baseEnum = (ICommonEnum)((Object)objs[i]);
            if (!String.valueOf(baseEnum.getCode()).equals(enumValue)) continue;
            return baseEnum.getDesc().toString();
        }
        return null;
    }

    public static Locale getLocale() {
        HttpServletRequest request;
        Locale requestLocale = Locale.ENGLISH;
        if (Objects.nonNull(RequestContextHolder.getRequestAttributes()) && (request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest()).getHeader("Accept-Language") == null) {
            requestLocale = request.getLocale();
        }
        return requestLocale;
    }

    public static String getLocaleValue(MessageSource messageSource, LocalizedField localizedField, String enumValue) throws ClassNotFoundException {
        Locale locale = LocalizedUtils.getLocale();
        if ("i18n_number".equals(enumValue)) {
            return NumberFormat.getNumberInstance(locale).format(localizedField.value());
        }
        if ("i18n_currency".equals(enumValue)) {
            return NumberFormat.getCurrencyInstance(locale).format(localizedField.value());
        }
        if ("i18n_percent".equals(enumValue)) {
            return NumberFormat.getPercentInstance(locale).format(localizedField.value());
        }
        String messageSourceKey = LocalizedUtils.getMessageSourceKey(localizedField.value(), enumValue);
        String defaultValue = localizedField.defaultValue();
        return MessageSourceUtils.getMessage(messageSource, messageSourceKey, null, defaultValue, locale);
    }
}

