/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.base;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.reflect.Field;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.gmwframework.cloud.common.base.ICommonEnum;
import org.gmwframework.cloud.common.base.IEnumHelper;

public class CodeDescEnumJsonDeserializer
extends JsonDeserializer<ICommonEnum> {
    public ICommonEnum deserialize(JsonParser jp, DeserializationContext context) {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        String currentName = jp.currentName();
        if (node == null) {
            return null;
        }
        Field field = FieldUtils.getDeclaredField(jp.getCurrentValue().getClass(), (String)currentName, (boolean)true);
        while (field == null) {
            Class<?> type = jp.getCurrentValue().getClass().getSuperclass();
            if (type == null) {
                throw new Exception();
            }
            field = FieldUtils.getDeclaredField(type, (String)currentName, (boolean)true);
        }
        JsonNode valNode = node.get("code");
        if (valNode.isInt()) {
            return IEnumHelper.getEnumTypeByCode(field.getType(), valNode.asInt());
        }
        if (valNode.isTextual()) {
            return IEnumHelper.getEnumTypeByCode(field.getType(), valNode.asText());
        }
        throw new Exception();
    }
}

