/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.base;

import io.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class PageableResult<T> {
    @ApiModelProperty(value="\u603b\u9875\u6570")
    private long pages;
    @ApiModelProperty(value="\u9875\u7801")
    private long current = 1L;
    @ApiModelProperty(value="\u6bcf\u9875\u6570\u91cf")
    private long size;
    @ApiModelProperty(value="\u603b\u6570\u91cf")
    protected long total;
    @ApiModelProperty(value="\u7ed3\u679c")
    protected List<T> records;

    public long getTotal() {
        if (this.total == 0L && this.records != null) {
            return this.records.size();
        }
        return this.total;
    }

    public <U> PageableResult<U> map(Function<? super T, ? extends U> func) {
        return PageableResult.builder().total(this.total).size(this.size).current(this.current).pages(this.pages).records(this.records.stream().map(func).collect(Collectors.toList())).build();
    }

    public static <T> PageableResultBuilder<T> builder() {
        return new PageableResultBuilder();
    }

    public long getPages() {
        return this.pages;
    }

    public long getCurrent() {
        return this.current;
    }

    public long getSize() {
        return this.size;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public void setPages(long pages) {
        this.pages = pages;
    }

    public void setCurrent(long current) {
        this.current = current;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setRecords(List<T> records) {
        this.records = records;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageableResult)) {
            return false;
        }
        PageableResult other = (PageableResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$records = this.getRecords();
        List<T> other$records = other.getRecords();
        return !(this$records == null ? other$records != null : !((Object)this$records).equals(other$records));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageableResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pages = this.getPages();
        result = result * 59 + (int)($pages >>> 32 ^ $pages);
        long $current = this.getCurrent();
        result = result * 59 + (int)($current >>> 32 ^ $current);
        long $size = this.getSize();
        result = result * 59 + (int)($size >>> 32 ^ $size);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $records = this.getRecords();
        result = result * 59 + ($records == null ? 43 : ((Object)$records).hashCode());
        return result;
    }

    public PageableResult() {
    }

    public PageableResult(long pages, long current, long size, long total, List<T> records) {
        this.pages = pages;
        this.current = current;
        this.size = size;
        this.total = total;
        this.records = records;
    }

    public String toString() {
        return "PageableResult(pages=" + this.getPages() + ", current=" + this.getCurrent() + ", size=" + this.getSize() + ", total=" + this.getTotal() + ", records=" + this.getRecords() + ")";
    }

    public static class PageableResultBuilder<T> {
        private long pages;
        private long current;
        private long size;
        private long total;
        private List<T> records;

        PageableResultBuilder() {
        }

        public PageableResultBuilder<T> pages(long pages) {
            this.pages = pages;
            return this;
        }

        public PageableResultBuilder<T> current(long current) {
            this.current = current;
            return this;
        }

        public PageableResultBuilder<T> size(long size) {
            this.size = size;
            return this;
        }

        public PageableResultBuilder<T> total(long total) {
            this.total = total;
            return this;
        }

        public PageableResultBuilder<T> records(List<T> records) {
            this.records = records;
            return this;
        }

        public PageableResult<T> build() {
            return new PageableResult<T>(this.pages, this.current, this.size, this.total, this.records);
        }

        public String toString() {
            return "PageableResult.PageableResultBuilder(pages=" + this.pages + ", current=" + this.current + ", size=" + this.size + ", total=" + this.total + ", records=" + this.records + ")";
        }
    }
}

