/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.httputil;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import java.util.Map;
import org.gmwframework.cloud.common.httputil.HttpClientUtil;
import org.gmwframework.cloud.common.httputil.HttpConfig;
import org.gmwframework.cloud.common.httputil.HttpResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHelper {
    private static final Logger log = LoggerFactory.getLogger(HttpHelper.class);

    public static <T> T post(Class<T> cls, String url, Map<String, String> requestMap, Map<String, String> header) throws Exception {
        return HttpHelper.post(cls, url, requestMap, header, null);
    }

    public static <T> T post(Class<T> cls, String url, Map<String, String> requestMap, Map<String, String> header, HttpConfig httpConfig) throws Exception {
        HttpResult httpResult = HttpClientUtil.post(url, requestMap, header, httpConfig);
        if (httpResult.getHttpStatus() == 200) {
            return (T)JSONObject.parseObject((String)httpResult.getHttpContent(), cls);
        }
        throw new Exception(httpResult.getHttpContent());
    }

    public static <T> T post(Class<T> cls, String url, Map<String, String> requestMap) throws Exception {
        return HttpHelper.post(cls, url, requestMap, null, null);
    }

    public static <T> T post(Class<T> cls, String url, Map<String, String> requestMap, HttpConfig config) throws Exception {
        return HttpHelper.post(cls, url, requestMap, null, config);
    }

    public static <T> T post(Class<T> cls, String url, String requestData, Map<String, String> header) throws Exception {
        HttpResult httpResult = HttpClientUtil.post(url, requestData, header, null);
        if (httpResult.getHttpStatus() == 200) {
            return (T)JSONObject.parseObject((String)httpResult.getHttpContent(), cls);
        }
        throw new Exception(httpResult.getHttpContent());
    }

    public static <T> T post(Class<T> cls, String url, String requestData) throws Exception {
        return HttpHelper.post(cls, url, requestData, null);
    }

    public static <T> T get(Class<T> cls, String url, Map<String, String> requestMap, Map<String, String> header, HttpConfig httpConfig) throws Exception {
        HttpResult httpResult = HttpClientUtil.get(url, requestMap, header, httpConfig);
        if (httpResult.getHttpStatus() == 200) {
            return (T)JSONObject.parseObject((String)httpResult.getHttpContent(), cls);
        }
        throw new Exception(httpResult.getHttpContent());
    }

    public static <T> T get(Class<T> cls, String url) throws Exception {
        return HttpHelper.get(cls, url, null, null, null);
    }

    public static <T> List<T> getList(Class<T> cls, String url) throws Exception {
        HttpResult httpResult = HttpClientUtil.get(url, null);
        if (httpResult.getHttpStatus() == 200) {
            return JSONObject.parseArray((String)httpResult.getHttpContent(), cls);
        }
        throw new Exception(httpResult.getHttpContent());
    }

    public static <T> T get(Class<T> cls, String url, Map<String, String> requestMap) throws Exception {
        return HttpHelper.get(cls, url, requestMap, null);
    }

    public static <T> T get(Class<T> cls, String url, Map<String, String> requestMap, HttpConfig httpConfig) throws Exception {
        return HttpHelper.get(cls, url, requestMap, null, httpConfig);
    }
}

