/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.utils;

import cn.hutool.core.util.ArrayUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import java.util.function.Predicate;

public class ArrayUtils
extends ArrayUtil {
    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        return ArrayUtils.distinctByKeys(keyExtractor);
    }

    public static <T> Predicate<T> distinctByKeys(Function<? super T, Object> ... keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> {
            String key = "";
            for (Function objectFunction : keyExtractor) {
                key = key + objectFunction.apply(t).toString();
            }
            return map.putIfAbsent(key, Boolean.TRUE) == null;
        };
    }

    public static <T> T randomOneObject(List<T> list) {
        if (list.size() > 1) {
            int n = ThreadLocalRandom.current().nextInt(list.size());
            return list.get(n);
        }
        return list.get(0);
    }

    public static int getPageCount(List<?> list, int pageSize) {
        if (list == null) {
            return 0;
        }
        int count = list.size();
        int pageCount = 0;
        pageCount = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
        return pageCount;
    }

    public static <T> List<T> startPage(List<T> list, int pageNum, int pageSize) {
        int toIndex;
        int fromIndex;
        int pageCount = ArrayUtils.getPageCount(list, pageSize);
        if (pageCount == 0 || pageNum > pageCount) {
            return null;
        }
        if (pageNum < pageCount) {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = fromIndex + pageSize;
        } else {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = list.size();
        }
        return list.subList(fromIndex, toIndex);
    }
}

