/*
 * Decompiled with CFR 0.152.
 */
package org.gmwframework.cloud.common.utils.copier;

import cn.hutool.core.collection.CollectionUtil;
import com.esotericsoftware.reflectasm.ConstructorAccess;
import com.google.common.collect.Maps;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.gmwframework.cloud.common.utils.copier.Converter;
import org.springframework.cglib.beans.BeanCopier;

public class WrappedBeanCopier {
    private static final Map<String, BeanCopier> BEAN_COPIER_CACHE = Maps.newConcurrentMap();
    private static final Map<String, ConstructorAccess<?>> CONSTRUCTOR_ACCESS_CACHE = Maps.newConcurrentMap();

    private static void copyProperties(Object source, Object target) {
        BeanCopier copier = WrappedBeanCopier.getBeanCopier(source.getClass(), target.getClass());
        copier.copy(source, target, null);
    }

    private static BeanCopier getBeanCopier(Class sourceClass, Class targetClass) {
        BeanCopier copier;
        String beanKey = WrappedBeanCopier.generateKey(sourceClass, targetClass);
        if (BEAN_COPIER_CACHE.containsKey(beanKey)) {
            copier = BEAN_COPIER_CACHE.get(beanKey);
        } else {
            copier = BeanCopier.create((Class)sourceClass, (Class)targetClass, (boolean)false);
            BEAN_COPIER_CACHE.put(beanKey, copier);
        }
        return copier;
    }

    private static String generateKey(Class<?> class1, Class<?> class2) {
        return class1.toString() + class2.toString();
    }

    public static <T> T copyProperties(Object source, Class<T> targetClass, Converter converter) {
        T t;
        if (source == null) {
            return null;
        }
        try {
            t = targetClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(String.format("Create new instance of %s failed: %s", targetClass, e.getMessage()));
        }
        WrappedBeanCopier.copyProperties(source, t);
        if (converter != null) {
            converter.convert(source, t);
        }
        return t;
    }

    public static <T> void simpleCopyProperties(T target, Object source, Converter converter) {
        WrappedBeanCopier.copyProperties(source, target);
        if (converter != null) {
            converter.convert(source, target);
        }
    }

    public static <T> List<T> copyPropertiesOfList(List<?> sourceList, Class<T> targetClass, Converter converter) {
        if (CollectionUtil.isEmpty(sourceList)) {
            return Lists.newArrayList();
        }
        if (targetClass.equals(Long.class) || targetClass.equals(String.class)) {
            return Lists.newArrayList((Iterator)((Iterator)((Object)sourceList)));
        }
        ConstructorAccess<T> constructorAccess = WrappedBeanCopier.getConstructorAccess(targetClass);
        ArrayList resultList = Lists.newArrayList();
        for (Object o : sourceList) {
            try {
                Object t = constructorAccess.newInstance();
                WrappedBeanCopier.copyProperties(o, t);
                if (converter != null) {
                    converter.convert(o, t);
                }
                resultList.add(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return resultList;
    }

    private static <T> ConstructorAccess<T> getConstructorAccess(Class<T> targetClass) {
        ConstructorAccess newAccess;
        ConstructorAccess<?> access = CONSTRUCTOR_ACCESS_CACHE.get(targetClass.toString());
        if (access != null) {
            return access;
        }
        try {
            newAccess = ConstructorAccess.get(targetClass);
            newAccess.newInstance();
            CONSTRUCTOR_ACCESS_CACHE.put(targetClass.toString(), newAccess);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Create new instance of %s failed: %s", targetClass, e.getMessage()));
        }
        return newAccess;
    }
}

