/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.lib.adapter;

import cn.handyplus.lib.adapter.BukkitScheduler;
import cn.handyplus.lib.adapter.FoliaScheduler;
import cn.handyplus.lib.adapter.HandyRunnable;
import cn.handyplus.lib.adapter.ServerTypeEnum;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class HandySchedulerUtil {
    protected static Plugin BUKKIT_PLUGIN;
    private static ServerTypeEnum SERVER_TYPE;

    private HandySchedulerUtil() {
    }

    public static void init(Plugin plugin) {
        BUKKIT_PLUGIN = plugin;
        SERVER_TYPE = ServerTypeEnum.getServerType();
    }

    public static boolean teleport(Entity entity, Location target) {
        return HandySchedulerUtil.teleport(entity, target, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static boolean teleport(Entity entity, Location target, PlayerTeleportEvent.TeleportCause cause) {
        if (HandySchedulerUtil.isFolia()) {
            return FoliaScheduler.teleport(entity, target, cause);
        }
        return BukkitScheduler.teleport(entity, target, cause);
    }

    public static void syncTeleport(Entity entity, Location target) {
        HandySchedulerUtil.syncTeleport(entity, target, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static void syncTeleport(Entity entity, Location target, PlayerTeleportEvent.TeleportCause cause) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.teleport(entity, target, cause);
        }
        BukkitScheduler.syncTeleport(entity, target, cause);
    }

    public static void performCommand(Player player, String command) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.performCommand(player, command);
            return;
        }
        BukkitScheduler.performCommand(player, command);
    }

    public static void addPotionEffects(Player player, List<PotionEffect> potionEffectList) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.addPotionEffects(player, potionEffectList);
            return;
        }
        BukkitScheduler.addPotionEffects(player, potionEffectList);
    }

    public static void removePotionEffect(Player player, PotionEffectType potionEffect) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.removePotionEffect(player, potionEffect);
            return;
        }
        BukkitScheduler.removePotionEffect(player, potionEffect);
    }

    public static void runTask(Runnable task) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTask(task);
            return;
        }
        BukkitScheduler.runTask(task);
    }

    public static void runTaskLater(Runnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLater(task, delay);
            return;
        }
        BukkitScheduler.runTaskLater(task, delay);
    }

    public static void runTaskTimer(Runnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimer(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimer(task, delay, period);
    }

    public static void runTaskTimer(HandyRunnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimer(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimer(task, delay, period);
    }

    public static void runTaskAsynchronously(Runnable task) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskAsynchronously(task);
            return;
        }
        BukkitScheduler.runTaskAsynchronously(task);
    }

    public static void runTaskLaterAsynchronously(Runnable task, long delay) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskLaterAsynchronously(task, delay);
            return;
        }
        BukkitScheduler.runTaskLaterAsynchronously(task, delay);
    }

    public static void runTaskTimerAsynchronously(Runnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimerAsynchronously(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimerAsynchronously(task, delay, period);
    }

    public static void runTaskTimerAsynchronously(HandyRunnable task, long delay, long period) {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.runTaskTimerAsynchronously(task, delay, period);
            return;
        }
        BukkitScheduler.runTaskTimerAsynchronously(task, delay, period);
    }

    public static void cancelTask() {
        if (HandySchedulerUtil.isFolia()) {
            FoliaScheduler.cancelTask();
        } else {
            BukkitScheduler.cancelTask();
        }
    }

    public static boolean isFolia() {
        return ServerTypeEnum.FOLIA.equals((Object)SERVER_TYPE);
    }
}

