/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.lib.adapter;

import cn.handyplus.lib.adapter.BukkitScheduler;
import cn.handyplus.lib.adapter.HandySchedulerUtil;
import java.util.Collection;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PlayerSchedulerUtil {
    private PlayerSchedulerUtil() {
    }

    public static boolean teleport(Entity entity, Location target) {
        return PlayerSchedulerUtil.teleport(entity, target, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static boolean teleport(Entity entity, Location target, PlayerTeleportEvent.TeleportCause cause) {
        if (HandySchedulerUtil.isFolia()) {
            entity.teleportAsync(target, cause);
            return true;
        }
        return entity.teleport(target, cause);
    }

    public static void syncTeleport(Entity entity, Location target) {
        PlayerSchedulerUtil.syncTeleport(entity, target, PlayerTeleportEvent.TeleportCause.PLUGIN);
    }

    public static void syncTeleport(Entity entity, Location target, PlayerTeleportEvent.TeleportCause cause) {
        if (HandySchedulerUtil.isFolia()) {
            entity.teleportAsync(target, cause);
        }
        BukkitScheduler.runTask(() -> entity.teleport(target, cause));
    }

    public static void performCommand(Player player, String command) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> PlayerSchedulerUtil.chat(player, command), () -> {});
            return;
        }
        PlayerSchedulerUtil.chat(player, command);
    }

    public static void syncPerformCommand(Player player, String command) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> PlayerSchedulerUtil.chat(player, command), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> PlayerSchedulerUtil.chat(player, command));
    }

    public static void syncPerformReplaceCommand(Player player, String command) {
        if (command.contains("[close]")) {
            HandySchedulerUtil.runTask(() -> ((Player)player).closeInventory());
            return;
        }
        if (command.contains("[op]")) {
            String newCommand = command.replace("[op]", "");
            PlayerSchedulerUtil.syncPerformOpCommand(player, newCommand);
            return;
        }
        if (command.contains("[console]")) {
            String trimCommand = command.replace("[console]", "").trim();
            HandySchedulerUtil.runTask(() -> Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)trimCommand));
            return;
        }
        PlayerSchedulerUtil.syncPerformCommand(player, command);
    }

    public static void performOpCommand(Player player, String command) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> PlayerSchedulerUtil.opChat(player, command), () -> {});
            return;
        }
        PlayerSchedulerUtil.opChat(player, command);
    }

    public static void syncPerformOpCommand(Player player, String command) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> PlayerSchedulerUtil.opChat(player, command), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> PlayerSchedulerUtil.opChat(player, command));
    }

    public static void addPotionEffects(LivingEntity entity, List<PotionEffect> potionEffectList) {
        if (potionEffectList == null || potionEffectList.isEmpty()) {
            return;
        }
        if (HandySchedulerUtil.isFolia()) {
            entity.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> entity.addPotionEffects((Collection)potionEffectList), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> entity.addPotionEffects((Collection)potionEffectList));
    }

    public static void removePotionEffect(LivingEntity entity, PotionEffectType potionEffect) {
        if (HandySchedulerUtil.isFolia()) {
            entity.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> entity.removePotionEffect(potionEffect), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> entity.removePotionEffect(potionEffect));
    }

    public static void playSound(Player player, Sound sound, float volume, float pitch) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> player.getWorld().playSound(player.getLocation(), sound, volume, pitch), () -> {});
            return;
        }
        player.getWorld().playSound(player.getLocation(), sound, volume, pitch);
    }

    public static void syncPlaySound(Player player, Sound sound, float volume, float pitch) {
        if (HandySchedulerUtil.isFolia()) {
            player.getScheduler().run(HandySchedulerUtil.BUKKIT_PLUGIN, a -> player.getWorld().playSound(player.getLocation(), sound, volume, pitch), () -> {});
            return;
        }
        BukkitScheduler.runTask(() -> player.getWorld().playSound(player.getLocation(), sound, volume, pitch));
    }

    private static void chat(Player player, String command) {
        player.chat("/" + command.trim());
    }

    private static void opChat(Player player, String command) {
        boolean op = player.isOp();
        try {
            if (!op) {
                player.setOp(true);
            }
            PlayerSchedulerUtil.chat(player, command);
        }
        finally {
            player.setOp(op);
        }
    }
}

