/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.lib.attribute;

import cn.handyplus.lib.attribute.AttributeEnum;
import cn.handyplus.lib.attribute.AttributePlusUtil;
import cn.handyplus.lib.attribute.AttributePlusV2Util;
import cn.handyplus.lib.attribute.AttributeSystemUtil;
import cn.handyplus.lib.attribute.MmoItemsUtil;
import cn.handyplus.lib.attribute.PotionEffectUtil;
import cn.handyplus.lib.attribute.SxAttributeUtil;
import cn.handyplus.lib.attribute.SxAttributeV2Util;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AttributeUtil {
    private static Plugin PLUGIN;
    private static boolean USE_AP_3;
    private static boolean USE_AP_2;
    private static boolean USE_AS;
    private static boolean USE_SX_3;
    private static boolean USE_SX_2;
    private static boolean USE_MMO;
    private static final AttributeUtil INSTANCE;

    private AttributeUtil() {
    }

    public static AttributeUtil getInstance(Plugin plugin) {
        PLUGIN = plugin;
        AttributeUtil.init();
        return INSTANCE;
    }

    public void addAttribute(Player player, List<String> attributeList, AttributeEnum attributeEnum) {
        if (attributeList == null || attributeList.isEmpty()) {
            return;
        }
        if (player == null) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: player\u4e0d\u80fd\u4e3anull");
        }
        attributeList = AttributeUtil.replaceChatColor(attributeList);
        switch (attributeEnum) {
            case ATTRIBUTE_PLUS: {
                if (USE_AP_3) {
                    AttributePlusUtil.getInstance().addAttribute(PLUGIN, player, attributeList);
                }
                if (!USE_AP_2) break;
                AttributePlusV2Util.getInstance().addAttribute(PLUGIN, player, attributeList);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.getInstance().addAttribute(PLUGIN, player, attributeList);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.getInstance().addAttribute(PLUGIN, player, attributeList);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.getInstance().addAttribute(PLUGIN, player, attributeList);
                break;
            }
            case MMO_ITEMS: {
                if (!USE_MMO) break;
                MmoItemsUtil.getInstance(PLUGIN).addAttribute(player, attributeList);
                break;
            }
            case POTION_EFFECT: {
                PotionEffectUtil.getInstance().addAttribute(player, attributeList);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    public void removeAttribute(Player player, AttributeEnum attributeEnum) {
        switch (attributeEnum) {
            case ALL: {
                if (USE_AP_3) {
                    AttributePlusUtil.getInstance().removeAttribute(PLUGIN, player);
                }
                if (USE_AP_2) {
                    AttributePlusV2Util.getInstance().removeAttribute(PLUGIN, player);
                }
                if (USE_AS) {
                    AttributeSystemUtil.getInstance().removeAttribute(PLUGIN, player);
                }
                if (USE_SX_3) {
                    SxAttributeUtil.getInstance().removeAttribute(PLUGIN, player);
                }
                if (USE_SX_2) {
                    SxAttributeV2Util.getInstance().removeAttribute(PLUGIN, player);
                }
                if (USE_MMO) {
                    MmoItemsUtil.getInstance(PLUGIN).removeAttribute(player);
                }
                PotionEffectUtil.getInstance().removeAttribute(player);
                break;
            }
            case ATTRIBUTE_PLUS: {
                if (USE_AP_3) {
                    AttributePlusUtil.getInstance().removeAttribute(PLUGIN, player);
                }
                if (!USE_AP_2) break;
                AttributePlusV2Util.getInstance().removeAttribute(PLUGIN, player);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.getInstance().removeAttribute(PLUGIN, player);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.getInstance().removeAttribute(PLUGIN, player);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.getInstance().removeAttribute(PLUGIN, player);
                break;
            }
            case MMO_ITEMS: {
                if (!USE_MMO) break;
                MmoItemsUtil.getInstance(PLUGIN).removeAttribute(player);
                break;
            }
            case POTION_EFFECT: {
                PotionEffectUtil.getInstance().removeAttribute(player);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    private static void init() {
        Plugin attributeSystem = Bukkit.getPluginManager().getPlugin("AttributeSystem");
        USE_AS = attributeSystem != null && attributeSystem.isEnabled();
        Plugin sxPlugin = Bukkit.getPluginManager().getPlugin("SX-Attribute");
        if (sxPlugin != null && sxPlugin.isEnabled()) {
            int firstPluginVersion = AttributeUtil.getFirstPluginVersion(sxPlugin);
            if (firstPluginVersion < 3) {
                USE_SX_2 = true;
            } else {
                USE_SX_3 = true;
            }
        } else {
            USE_SX_2 = false;
            USE_SX_3 = false;
        }
        Plugin apPlugin = Bukkit.getPluginManager().getPlugin("AttributePlus");
        if (apPlugin != null && apPlugin.isEnabled()) {
            int firstPluginVersion = AttributeUtil.getFirstPluginVersion(apPlugin);
            if (firstPluginVersion < 3) {
                USE_AP_2 = true;
            } else {
                USE_AP_3 = true;
            }
        } else {
            USE_AP_2 = false;
            USE_AP_3 = false;
        }
        Plugin mmoItems = Bukkit.getPluginManager().getPlugin("MMOItems");
        if (mmoItems != null && mmoItems.isEnabled()) {
            USE_MMO = true;
            MmoItemsUtil.getInstance(PLUGIN);
        } else {
            USE_MMO = false;
        }
    }

    private static int getFirstPluginVersion(Plugin plugin) {
        String version = plugin.getDescription().getVersion();
        String[] split = version.split("\\.");
        return Integer.parseInt(split[0]);
    }

    private static List<String> replaceChatColor(List<String> strList) {
        ArrayList<String> list = new ArrayList<String>();
        if (strList == null || strList.isEmpty()) {
            return list;
        }
        for (String str : strList) {
            list.add(str.replace("&", "\u00a7"));
        }
        return list;
    }

    static {
        INSTANCE = new AttributeUtil();
    }
}

