/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.lib.attribute;

import cn.handyplus.lib.attribute.AttributeEnum;
import cn.handyplus.lib.attribute.AttributePlusUtil;
import cn.handyplus.lib.attribute.AttributePlusV2Util;
import cn.handyplus.lib.attribute.AttributeSystemUtil;
import cn.handyplus.lib.attribute.MmoItemsUtil;
import cn.handyplus.lib.attribute.MythicLibUtil;
import cn.handyplus.lib.attribute.PotionEffectUtil;
import cn.handyplus.lib.attribute.SxAttributeUtil;
import cn.handyplus.lib.attribute.SxAttributeV2Util;
import cn.handyplus.lib.util.BaseUtil;
import java.util.List;
import java.util.Optional;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class AttributeUtil {
    private static boolean USE_AP_3;
    private static boolean USE_AP_2;
    private static boolean USE_AS;
    private static boolean USE_SX_3;
    private static boolean USE_SX_2;
    private static boolean USE_MMO;
    private static boolean USE_MYTHIC;
    private static final AttributeUtil INSTANCE;

    private AttributeUtil() {
    }

    public static AttributeUtil getInstance() {
        AttributeUtil.init();
        return INSTANCE;
    }

    public static void clearCache(Player player) {
        PotionEffectUtil.PLAYER_EFFECT_MAP.remove(player.getUniqueId());
    }

    public static void clearCache() {
        PotionEffectUtil.PLAYER_EFFECT_MAP.clear();
    }

    public void addAttribute(Player player, List<String> attributeList, AttributeEnum attributeEnum) {
        if (attributeList == null || attributeList.isEmpty()) {
            return;
        }
        if (player == null) {
            throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: player\u4e0d\u80fd\u4e3anull");
        }
        attributeList = BaseUtil.replaceChatColor(attributeList);
        switch (attributeEnum) {
            case ATTRIBUTE_PLUS: {
                if (USE_AP_3) {
                    AttributePlusUtil.addAttribute(player, attributeList);
                }
                if (!USE_AP_2) break;
                AttributePlusV2Util.addAttribute(player, attributeList);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.addAttribute(player, attributeList);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.addAttribute(player, attributeList);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.addAttribute(player, attributeList);
                break;
            }
            case MMO_ITEMS: {
                if (!USE_MMO) break;
                MmoItemsUtil.getInstance().addAttribute(player, attributeList);
                break;
            }
            case POTION_EFFECT: {
                PotionEffectUtil.addAttribute(player, attributeList);
                break;
            }
            case MYTHIC_LIB: {
                if (!USE_MYTHIC) break;
                MythicLibUtil.addAttribute(player, attributeList);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    public void removeAttribute(Player player, AttributeEnum attributeEnum) {
        switch (attributeEnum) {
            case ALL: {
                if (USE_AP_3) {
                    AttributePlusUtil.removeAttribute(player);
                }
                if (USE_AP_2) {
                    AttributePlusV2Util.removeAttribute(player);
                }
                if (USE_AS) {
                    AttributeSystemUtil.removeAttribute(player);
                }
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute(player);
                }
                if (USE_SX_2) {
                    SxAttributeV2Util.removeAttribute(player);
                }
                if (USE_MMO) {
                    MmoItemsUtil.getInstance().removeAttribute(player);
                }
                if (USE_MYTHIC) {
                    MythicLibUtil.removeAttribute(player);
                }
                PotionEffectUtil.removeAttribute(player);
                break;
            }
            case ATTRIBUTE_PLUS: {
                if (USE_AP_3) {
                    AttributePlusUtil.removeAttribute(player);
                }
                if (!USE_AP_2) break;
                AttributePlusV2Util.removeAttribute(player);
                break;
            }
            case ATTRIBUTE_SYSTEM: {
                if (!USE_AS) break;
                AttributeSystemUtil.removeAttribute(player);
                break;
            }
            case SX_ATTRIBUTE: {
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute(player);
                }
                if (!USE_SX_2) break;
                SxAttributeV2Util.removeAttribute(player);
                break;
            }
            case MMO_ITEMS: {
                if (!USE_MMO) break;
                MmoItemsUtil.getInstance().removeAttribute(player);
                break;
            }
            case POTION_EFFECT: {
                PotionEffectUtil.removeAttribute(player);
                break;
            }
            case MYTHIC_LIB: {
                if (!USE_MYTHIC) break;
                MythicLibUtil.removeAttribute(player);
                break;
            }
            default: {
                throw new RuntimeException("\u53c2\u6570\u5f02\u5e38: attributeEnum \u9519\u8bef");
            }
        }
    }

    private static void init() {
        USE_AS = BaseUtil.hook((String)"AttributeSystem").isPresent();
        Optional sxPluginOpt = BaseUtil.hook((String)"SX-Attribute");
        if (sxPluginOpt.isPresent()) {
            if (BaseUtil.getFirstPluginVersion((Plugin)((Plugin)sxPluginOpt.get())) < 3) {
                USE_SX_2 = true;
            } else {
                USE_SX_3 = true;
            }
        } else {
            USE_SX_2 = false;
            USE_SX_3 = false;
        }
        Optional apPluginOpt = BaseUtil.hook((String)"AttributePlus");
        if (apPluginOpt.isPresent()) {
            if (BaseUtil.getFirstPluginVersion((Plugin)((Plugin)apPluginOpt.get())) < 3) {
                USE_AP_2 = true;
            } else {
                USE_AP_3 = true;
            }
        } else {
            USE_AP_2 = false;
            USE_AP_3 = false;
        }
        Optional mmoItems = BaseUtil.hook((String)"MMOItems");
        if (mmoItems.isPresent()) {
            USE_MMO = true;
            MmoItemsUtil.getInstance();
        } else {
            USE_MMO = false;
        }
        USE_MYTHIC = BaseUtil.hook((String)"MythicLib").isPresent();
        if (USE_MYTHIC) {
            USE_MYTHIC = MythicLibUtil.isNewVersion();
        }
    }

    static {
        INSTANCE = new AttributeUtil();
    }
}

