package cn.handyplus.lib.attribute;

import cn.handyplus.lib.util.BaseUtil;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

import java.util.List;
import java.util.Optional;

/**
 * 属性工具
 *
 * @author handy
 */
public class AttributeUtil {

    private static boolean USE_AP_3;
    private static boolean USE_AP_2;
    private static boolean USE_AS;
    private static boolean USE_SX_3;
    private static boolean USE_SX_2;
    private static boolean USE_MMO;
    private static boolean USE_MYTHIC;

    private AttributeUtil() {
    }

    private static final AttributeUtil INSTANCE = new AttributeUtil();

    /**
     * 获取唯一实例
     *
     * @return this
     */
    public static AttributeUtil getInstance() {
        init();
        return INSTANCE;
    }

    /**
     * 清理缓存
     *
     * @param player 玩家
     * @since 1.1.1
     */
    public static void clearCache(Player player) {
        PotionEffectUtil.PLAYER_EFFECT_MAP.remove(player.getUniqueId());
    }

    /**
     * 清理缓存
     *
     * @since 1.1.1
     */
    public static void clearCache() {
        PotionEffectUtil.PLAYER_EFFECT_MAP.clear();
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性
     * @param attributeEnum 属性类型
     */
    public void addAttribute(Player player, List<String> attributeList, AttributeEnum attributeEnum) {
        if (attributeList == null || attributeList.isEmpty()) {
            return;
        }
        if (player == null || !player.isOnline()) {
            return;
        }
        attributeList = BaseUtil.replaceChatColor(attributeList);
        switch (attributeEnum) {
            case ATTRIBUTE_PLUS:
                if (USE_AP_3) {
                    AttributePlusUtil.addAttribute(player, attributeList);
                }
                if (USE_AP_2) {
                    AttributePlusV2Util.addAttribute(player, attributeList);
                }
                break;
            case ATTRIBUTE_SYSTEM:
                if (USE_AS) {
                    AttributeSystemUtil.addAttribute(player, attributeList);
                }
                break;
            case SX_ATTRIBUTE:
                if (USE_SX_3) {
                    SxAttributeUtil.addAttribute(player, attributeList);
                }
                if (USE_SX_2) {
                    SxAttributeV2Util.addAttribute(player, attributeList);
                }
                break;
            case MMO_ITEMS:
                if (USE_MMO) {
                    MmoItemsUtil.getInstance().addAttribute(player, attributeList);
                }
                break;
            case POTION_EFFECT:
                PotionEffectUtil.addAttribute(player, attributeList);
                break;
            case MYTHIC_LIB:
                if (USE_MYTHIC) {
                    MythicLibUtil.addAttribute(player, attributeList);
                }
                break;
            default:
                throw new RuntimeException("参数异常: attributeEnum 错误");
        }
    }

    /**
     * 移除玩家属性
     *
     * @param player        玩家
     * @param attributeEnum 属性类型
     */
    public void removeAttribute(Player player, AttributeEnum attributeEnum) {
        switch (attributeEnum) {
            case ALL:
                if (USE_AP_3) {
                    AttributePlusUtil.removeAttribute(player);
                }
                if (USE_AP_2) {
                    AttributePlusV2Util.removeAttribute(player);
                }
                if (USE_AS) {
                    AttributeSystemUtil.removeAttribute(player);
                }
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute(player);
                }
                if (USE_SX_2) {
                    SxAttributeV2Util.removeAttribute(player);
                }
                if (USE_MMO) {
                    MmoItemsUtil.getInstance().removeAttribute(player);
                }
                if (USE_MYTHIC) {
                    MythicLibUtil.removeAttribute(player);
                }
                // 清理药水
                PotionEffectUtil.removeAttribute(player);
                break;
            case ATTRIBUTE_PLUS:
                if (USE_AP_3) {
                    AttributePlusUtil.removeAttribute(player);
                }
                if (USE_AP_2) {
                    AttributePlusV2Util.removeAttribute(player);
                }
                break;
            case ATTRIBUTE_SYSTEM:
                if (USE_AS) {
                    AttributeSystemUtil.removeAttribute(player);
                }
                break;
            case SX_ATTRIBUTE:
                if (USE_SX_3) {
                    SxAttributeUtil.removeAttribute(player);
                }
                if (USE_SX_2) {
                    SxAttributeV2Util.removeAttribute(player);
                }
                break;
            case MMO_ITEMS:
                if (USE_MMO) {
                    MmoItemsUtil.getInstance().removeAttribute(player);
                }
                break;
            case POTION_EFFECT:
                PotionEffectUtil.removeAttribute(player);
                break;
            case MYTHIC_LIB:
                if (USE_MYTHIC) {
                    MythicLibUtil.removeAttribute(player);
                }
                break;
            default:
                throw new RuntimeException("参数异常: attributeEnum 错误");
        }
    }

    /**
     * 初始化版本
     */
    private static void init() {
        // 加载as
        USE_AS = BaseUtil.hook("AttributeSystem").isPresent();
        // 加载sx
        Optional<Plugin> sxPluginOpt = BaseUtil.hook("SX-Attribute");
        if (sxPluginOpt.isPresent()) {
            if (BaseUtil.getFirstPluginVersion(sxPluginOpt.get()) < 3) {
                USE_SX_2 = true;
            } else {
                USE_SX_3 = true;
            }
        } else {
            USE_SX_2 = false;
            USE_SX_3 = false;
        }
        // 加载ap
        Optional<Plugin> apPluginOpt = BaseUtil.hook("AttributePlus");
        if (apPluginOpt.isPresent()) {
            if (BaseUtil.getFirstPluginVersion(apPluginOpt.get()) < 3) {
                USE_AP_2 = true;
            } else {
                USE_AP_3 = true;
            }
        } else {
            USE_AP_2 = false;
            USE_AP_3 = false;
        }
        // 加载mmo属性
        Optional<Plugin> mmoItems = BaseUtil.hook("MMOItems");
        if (mmoItems.isPresent()) {
            USE_MMO = true;
            MmoItemsUtil.getInstance();
        } else {
            USE_MMO = false;
        }
        // 加载MythicLib
        USE_MYTHIC = BaseUtil.hook("MythicLib").isPresent();
        if (USE_MYTHIC) {
            USE_MYTHIC = MythicLibUtil.isNewVersion();
        }
    }

}