/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.lib.attribute;

import cn.handyplus.lib.attribute.PotionEffectParam;
import cn.handyplus.lib.constants.BaseConstants;
import cn.handyplus.lib.constants.VersionCheckEnum;
import cn.handyplus.lib.core.CollUtil;
import cn.handyplus.lib.core.JsonUtil;
import cn.handyplus.lib.expand.adapter.PlayerSchedulerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectUtil {
    protected static final Map<UUID, List<PotionEffectType>> PLAYER_EFFECT_MAP = new ConcurrentHashMap<UUID, List<PotionEffectType>>();

    private PotionEffectUtil() {
    }

    protected static void addAttribute(Player player, List<String> attributeList) {
        ArrayList<PotionEffectParam> peList = new ArrayList<PotionEffectParam>();
        for (String attribute : attributeList) {
            PotionEffectParam potionEffectParam = (PotionEffectParam)JsonUtil.toBean((String)attribute, PotionEffectParam.class);
            peList.add(potionEffectParam);
        }
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        ArrayList<PotionEffectType> potionEffectTypeList = new ArrayList<PotionEffectType>();
        for (PotionEffectParam potionEffectParam : peList) {
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)potionEffectParam.getPotionName());
            if (potionEffectType == null) continue;
            PotionEffect potionEffect = PotionEffectUtil.getPotionEffect(potionEffectParam, potionEffectType);
            potionEffects.add(potionEffect);
            potionEffectTypeList.add(potionEffectType);
        }
        if (!potionEffects.isEmpty()) {
            PlayerSchedulerUtil.addPotionEffects((LivingEntity)player, potionEffects);
            List typeList = PLAYER_EFFECT_MAP.getOrDefault(player.getUniqueId(), new ArrayList());
            typeList.addAll(potionEffectTypeList);
            typeList = typeList.stream().distinct().collect(Collectors.toList());
            PLAYER_EFFECT_MAP.put(player.getUniqueId(), typeList);
        }
    }

    private static PotionEffect getPotionEffect(PotionEffectParam potionEffectParam, PotionEffectType potionEffectType) {
        int potionLevel = potionEffectParam.getPotionLevel() - 1;
        if (potionLevel < 0) {
            potionLevel = 0;
        }
        PotionEffect potionEffect = BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId() ? new PotionEffect(potionEffectType, 1728000, potionLevel, false) : new PotionEffect(potionEffectType, 1728000, potionLevel, false, potionEffectParam.getPotionHide() == false);
        return potionEffect;
    }

    protected static void removeAttribute(Player player) {
        Collection activePotionEffects = player.getActivePotionEffects();
        if (activePotionEffects.isEmpty()) {
            return;
        }
        List<PotionEffectType> potionEffectTypeList = PLAYER_EFFECT_MAP.get(player.getUniqueId());
        if (CollUtil.isEmpty(potionEffectTypeList)) {
            return;
        }
        for (PotionEffect potionEffect : activePotionEffects) {
            if (!potionEffectTypeList.contains(potionEffect.getType())) continue;
            PlayerSchedulerUtil.removePotionEffect((LivingEntity)player, (PotionEffectType)potionEffect.getType());
        }
        PLAYER_EFFECT_MAP.remove(player.getUniqueId());
    }
}

