package cn.handyplus.lib.attribute;

import cn.handyplus.lib.InitApi;
import org.bukkit.entity.Player;
import org.serverct.ersha.api.AttributeAPI;

import java.util.List;

/**
 * AttributePlus 兼容
 *
 * @author handy
 */
public class AttributePlusUtil {

    private AttributePlusUtil() {
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性
     */
    protected static void addAttribute(Player player, List<String> attributeList) {
        AttributeAPI.addSourceAttribute(AttributeAPI.getAttrData(player), InitApi.PLUGIN.getName(), attributeList);
    }

    /**
     * 移除玩家属性
     *
     * @param player 玩家
     */
    protected static void removeAttribute(Player player) {
        AttributeAPI.takeSourceAttribute(AttributeAPI.getAttrData(player), InitApi.PLUGIN.getName());
    }

}