/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.lib.attribute;

import cn.handyplus.lib.attribute.MmoParam;
import cn.handyplus.lib.attribute.MmoPlayerInventory;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.List;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class MmoItemsUtil {
    private static MmoItemsUtil INSTANCE;

    private MmoItemsUtil() {
    }

    protected static MmoItemsUtil getInstance(Plugin plugin) {
        if (INSTANCE == null) {
            INSTANCE = new MmoItemsUtil();
            new MmoPlayerInventory(plugin);
        }
        return INSTANCE;
    }

    protected void addAttribute(Player player, List<String> attributeList) {
        ArrayList<String> mmoList = new ArrayList<String>();
        for (String attribute : attributeList) {
            MmoParam mmoParam = (MmoParam)new Gson().fromJson(attribute, MmoParam.class);
            if (mmoParam == null || mmoParam.getItemStr() == null || "".equals(mmoParam.getItemStr())) continue;
            mmoList.add(mmoParam.getItemStr());
        }
        ArrayList<ItemStack> itemStackList = new ArrayList<ItemStack>();
        for (String itemStackStr : mmoList) {
            ItemStack itemStack = MmoItemsUtil.itemStackDeserialize(itemStackStr);
            itemStackList.add(itemStack);
        }
        MmoPlayerInventory.MMO_ITEMS_BUFF_MAP.put(player.getUniqueId(), itemStackList);
        PlayerData.get((OfflinePlayer)player).updateInventory();
    }

    protected void removeAttribute(Player player) {
        MmoPlayerInventory.MMO_ITEMS_BUFF_MAP.remove(player.getUniqueId());
    }

    private static ItemStack itemStackDeserialize(String str) {
        ItemStack item;
        YamlConfiguration yml = new YamlConfiguration();
        try {
            yml.loadFromString(str);
            item = yml.getItemStack("item");
        }
        catch (InvalidConfigurationException ex) {
            item = new ItemStack(Material.AIR, 1);
        }
        return item;
    }
}

