package cn.handyplus.lib.attribute;

import cn.handyplus.lib.util.ItemStackUtil;
import com.google.gson.Gson;
import net.Indyuce.mmoitems.api.player.PlayerData;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

import java.util.ArrayList;
import java.util.List;

/**
 * MmoItem工具类
 *
 * @author handy
 */
public class MmoItemsUtil {

    private MmoItemsUtil() {
    }

    private static MmoItemsUtil INSTANCE;

    /**
     * 获取唯一实例
     *
     * @return this
     */
    protected static MmoItemsUtil getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MmoItemsUtil();
            new MmoPlayerInventory();
        }
        return INSTANCE;
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性列表
     */
    protected void addAttribute(Player player, List<String> attributeList) {
        List<String> mmoList = new ArrayList<>();
        for (String attribute : attributeList) {
            MmoParam mmoParam = new Gson().fromJson(attribute, MmoParam.class);
            if (mmoParam != null && mmoParam.getItemStr() != null && !mmoParam.getItemStr().isEmpty()) {
                mmoList.add(mmoParam.getItemStr());
            }
        }
        List<ItemStack> itemStackList = new ArrayList<>();
        for (String itemStackStr : mmoList) {
            ItemStack itemStack = ItemStackUtil.itemStackDeserialize(itemStackStr);
            itemStackList.add(itemStack);
        }
        MmoPlayerInventory.MMO_ITEMS_BUFF_MAP.put(player.getUniqueId(), itemStackList);
        // 立即刷新数据
        PlayerData.get(player).updateInventory();
    }

    /**
     * 移除玩家属性
     *
     * @param player 玩家
     */
    protected void removeAttribute(Player player) {
        MmoPlayerInventory.MMO_ITEMS_BUFF_MAP.remove(player.getUniqueId());
    }

}