package cn.handyplus.lib.attribute;

import cn.handyplus.lib.InitApi;
import cn.handyplus.lib.core.JsonUtil;
import cn.handyplus.lib.core.NumberUtil;
import cn.handyplus.lib.util.BaseUtil;
import cn.handyplus.lib.util.MessageUtil;
import io.lumine.mythic.lib.api.player.MMOPlayerData;
import io.lumine.mythic.lib.api.stat.StatInstance;
import io.lumine.mythic.lib.api.stat.StatMap;
import io.lumine.mythic.lib.api.stat.modifier.StatModifier;
import io.lumine.mythic.lib.player.modifier.ModifierType;
import org.bukkit.entity.Player;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * MythicLib支持
 *
 * @author handy
 * @since 1.0.3
 */
public class MythicLibUtil {

    private static Boolean IS_NEW_VERSION;

    private MythicLibUtil() {
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性列表
     */
    protected static void addAttribute(Player player, List<String> attributeList) {
        MMOPlayerData playerData = MMOPlayerData.get(player.getUniqueId());
        Map<String, Double> aggregateData = aggregateData(attributeList);
        for (String attributeName : aggregateData.keySet()) {
            StatModifier experienceModifier = new StatModifier(InitApi.PLUGIN.getName(),
                    attributeName,
                    aggregateData.get(attributeName),
                    ModifierType.FLAT);
            experienceModifier.register(playerData);
        }
    }

    /**
     * 移除玩家属性
     *
     * @param player 玩家
     */
    protected static void removeAttribute(Player player) {
        MMOPlayerData playerData = MMOPlayerData.get(player.getUniqueId());
        StatMap statMap = playerData.getStatMap();
        for (StatInstance instance : statMap.getInstances()) {
            instance.removeIf(i -> i.equals(InitApi.PLUGIN.getName()));
        }
    }

    /**
     * 是否新版本
     *
     * @return true 是
     */
    protected static boolean isNewVersion() {
        if (IS_NEW_VERSION != null) {
            return IS_NEW_VERSION;
        }
        try {
            Class.forName("io.lumine.mythic.lib.api.player.MMOPlayerData");
            IS_NEW_VERSION = true;
        } catch (ClassNotFoundException e) {
            IS_NEW_VERSION = false;
        }
        return IS_NEW_VERSION;
    }

    /**
     * 合并相同属性
     *
     * @param attributeList 属性
     * @return 合并后的数据
     * @since 1.1.5
     */
    private static Map<String, Double> aggregateData(List<String> attributeList) {
        Map<String, Double> resultMap = new HashMap<>();
        for (String attribute : attributeList) {
            String[] split = attribute.split(":");
            // key 移除颜色代码 -转换_ 转大写
            String attributeName = BaseUtil.stripColor(split[0].trim()).toUpperCase().replace("-", "_");
            // value
            Double number = NumberUtil.isNumericToDouble(split[1].trim(), 0.00);
            resultMap.put(attributeName, resultMap.getOrDefault(attributeName, 0.0) + number);
        }
        MessageUtil.sendConsoleDebugMessage("最终属性:" + JsonUtil.toJson(resultMap));
        return resultMap;
    }

}