package cn.handyplus.lib.attribute;

import com.google.gson.Gson;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 药水效果
 *
 * @author handy
 */
public class PotionEffectUtil {
    private PotionEffectUtil() {
    }

    private static final PotionEffectUtil INSTANCE = new PotionEffectUtil();

    public static PotionEffectUtil getInstance() {
        return INSTANCE;
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性
     */
    protected void addAttribute(Player player, List<String> attributeList) {
        // 转化格式
        List<PotionEffectParam> peList = new ArrayList<>();
        for (String attribute : attributeList) {
            PotionEffectParam potionEffectParam = new Gson().fromJson(attribute, PotionEffectParam.class);
            peList.add(potionEffectParam);
        }
        // 处理药水添加
        List<PotionEffect> potionEffects = new ArrayList<>();
        for (PotionEffectParam potionEffectParam : peList) {
            PotionEffectType potionEffectType = PotionEffectType.getByName(potionEffectParam.getPotionName());
            if (potionEffectType == null) {
                continue;
            }
            int potionLevel = potionEffectParam.getPotionLevel() - 1;
            if (potionLevel < 0) {
                potionLevel = 0;
            }
            PotionEffect potionEffect;
            // 默认一天
            if (this.isOldVersion()) {
                potionEffect = new PotionEffect(potionEffectType, 1728000, potionLevel, false);
            } else {
                potionEffect = new PotionEffect(potionEffectType, 1728000, potionLevel, false, !potionEffectParam.getPotionHide());
            }
            potionEffects.add(potionEffect);
        }
        if (!potionEffects.isEmpty()) {
            player.addPotionEffects(potionEffects);
        }
    }

    /**
     * 移除玩家药水属性
     *
     * @param player 玩家
     */
    protected void removeAttribute(Player player) {
        Collection<PotionEffect> activePotionEffects = player.getActivePotionEffects();
        if (activePotionEffects.isEmpty()) {
            return;
        }
        for (PotionEffect potionEffect : activePotionEffects) {
            // 不清理正常药水效果
            if (potionEffect.getDuration() <= 8 * 60 * 20) {
                continue;
            }
            player.removePotionEffect(potionEffect.getType());
        }
    }

    /**
     * 判断是否1.7
     *
     * @return 是
     */
    private boolean isOldVersion() {
        String version = Bukkit.getVersion();
        version = version.substring(version.indexOf(":") + 2);
        return version.contains("1.7");
    }

}