/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.lib.attribute;

import cn.handyplus.lib.attribute.PotionEffectParam;
import cn.handyplus.lib.constants.BaseConstants;
import cn.handyplus.lib.constants.VersionCheckEnum;
import cn.handyplus.lib.expand.adapter.HandySchedulerUtil;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PotionEffectUtil {
    private PotionEffectUtil() {
    }

    protected static void addAttribute(Player player, List<String> attributeList) {
        ArrayList<PotionEffectParam> peList = new ArrayList<PotionEffectParam>();
        for (String attribute : attributeList) {
            PotionEffectParam potionEffectParam = (PotionEffectParam)new Gson().fromJson(attribute, PotionEffectParam.class);
            peList.add(potionEffectParam);
        }
        ArrayList<PotionEffect> potionEffects = new ArrayList<PotionEffect>();
        for (PotionEffectParam potionEffectParam : peList) {
            PotionEffectType potionEffectType = PotionEffectType.getByName((String)potionEffectParam.getPotionName());
            if (potionEffectType == null) continue;
            int potionLevel = potionEffectParam.getPotionLevel() - 1;
            if (potionLevel < 0) {
                potionLevel = 0;
            }
            PotionEffect potionEffect = BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId() ? new PotionEffect(potionEffectType, 1728000, potionLevel, false) : new PotionEffect(potionEffectType, 1728000, potionLevel, false, potionEffectParam.getPotionHide() == false);
            potionEffects.add(potionEffect);
        }
        if (!potionEffects.isEmpty()) {
            HandySchedulerUtil.addPotionEffects((Player)player, potionEffects);
        }
    }

    protected static void removeAttribute(Player player) {
        Collection activePotionEffects = player.getActivePotionEffects();
        if (activePotionEffects.isEmpty()) {
            return;
        }
        for (PotionEffect potionEffect : activePotionEffects) {
            PotionEffectType potionEffectType;
            if (potionEffect.getDuration() <= 9600 || (potionEffectType = PotionEffectType.getByName((String)"BAD_OMEN")) != null && potionEffectType.equals((Object)potionEffect.getType()) && potionEffect.getDuration() <= 120000) continue;
            HandySchedulerUtil.removePotionEffect((Player)player, (PotionEffectType)potionEffect.getType());
        }
    }
}

