package cn.handyplus.lib.attribute;

import cn.handyplus.lib.constants.BaseConstants;
import cn.handyplus.lib.constants.VersionCheckEnum;
import cn.handyplus.lib.expand.adapter.HandySchedulerUtil;
import cn.handyplus.lib.expand.adapter.PlayerSchedulerUtil;
import com.google.gson.Gson;
import org.bukkit.entity.Player;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/**
 * 药水效果
 *
 * @author handy
 */
public class PotionEffectUtil {

    private PotionEffectUtil() {
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性
     */
    protected static void addAttribute(Player player, List<String> attributeList) {
        // 转化格式
        List<PotionEffectParam> peList = new ArrayList<>();
        for (String attribute : attributeList) {
            PotionEffectParam potionEffectParam = new Gson().fromJson(attribute, PotionEffectParam.class);
            peList.add(potionEffectParam);
        }
        // 处理药水添加
        List<PotionEffect> potionEffects = new ArrayList<>();
        for (PotionEffectParam potionEffectParam : peList) {
            PotionEffectType potionEffectType = PotionEffectType.getByName(potionEffectParam.getPotionName());
            if (potionEffectType == null) {
                continue;
            }
            int potionLevel = potionEffectParam.getPotionLevel() - 1;
            if (potionLevel < 0) {
                potionLevel = 0;
            }
            PotionEffect potionEffect;
            // 默认一天
            if (BaseConstants.VERSION_ID < VersionCheckEnum.V_1_8.getVersionId()) {
                potionEffect = new PotionEffect(potionEffectType, 1728000, potionLevel, false);
            } else {
                potionEffect = new PotionEffect(potionEffectType, 1728000, potionLevel, false, !potionEffectParam.getPotionHide());
            }
            potionEffects.add(potionEffect);
        }
        if (!potionEffects.isEmpty()) {
            PlayerSchedulerUtil.addPotionEffects(player, potionEffects);
        }
    }

    /**
     * 移除玩家药水属性
     *
     * @param player 玩家
     */
    protected static void removeAttribute(Player player) {
        Collection<PotionEffect> activePotionEffects = player.getActivePotionEffects();
        if (activePotionEffects.isEmpty()) {
            return;
        }
        for (PotionEffect potionEffect : activePotionEffects) {
            // 不清理正常药水效果 8分钟内
            if (potionEffect.getDuration() <= 8 * 60 * 20) {
                continue;
            }
            // 不祥之兆 特殊处理 这玩意持续100分钟
            PotionEffectType potionEffectType = PotionEffectType.getByName("BAD_OMEN");
            if (potionEffectType != null && potionEffectType.equals(potionEffect.getType()) && potionEffect.getDuration() <= 100 * 60 * 20) {
                continue;
            }
            PlayerSchedulerUtil.removePotionEffect(player, potionEffect.getType());
        }
    }

}