package cn.handyplus.lib.attribute;

import cn.handyplus.lib.InitApi;
import github.saukiya.sxattribute.SXAttribute;
import github.saukiya.sxattribute.data.attribute.SXAttributeData;
import org.bukkit.entity.Player;

import java.util.List;

/**
 * SxAttribute V3 版本兼容
 *
 * @author handy
 */
public class SxAttributeUtil {

    private SxAttributeUtil() {
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性列表
     */
    protected static void addAttribute(Player player, List<String> attributeList) {
        SXAttributeData data = SXAttribute.getApi().loadListData(attributeList);
        SXAttribute.getApi().setEntityAPIData(InitApi.PLUGIN.getClass(), player.getUniqueId(), data);
    }

    /**
     * 移除玩家属性
     *
     * @param player 玩家
     */
    protected static void removeAttribute(Player player) {
        SXAttribute.getApi().removeEntityAPIData(InitApi.PLUGIN.getClass(), player.getUniqueId());
    }

}