package cn.handyplus.lib.attribute;

import cn.handyplus.lib.InitApi;
import github.saukiya.sxattribute.SXAttribute;
import github.saukiya.sxattribute.data.attribute.SXAttributeData;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

import java.util.List;

/**
 * SxAttribute V2 版本兼容
 *
 * @author handy
 */
public class SxAttributeV2Util {

    private SxAttributeV2Util() {
    }

    /**
     * 给玩家添加属性
     *
     * @param player        玩家
     * @param attributeList 属性
     */
    protected static void addAttribute(Player player, List<String> attributeList) {
        ItemStack itemStack = new ItemStack(Material.NAME_TAG);
        ItemMeta itemMeta = itemStack.getItemMeta();
        assert itemMeta != null;
        itemMeta.setDisplayName(InitApi.PLUGIN.getName());
        itemMeta.setLore(attributeList);
        itemStack.setItemMeta(itemMeta);
        SXAttributeData sxAttributeData = new SXAttributeData();
        sxAttributeData.add(SXAttribute.getApi().getItemData(null, null, itemStack));
        SXAttribute.getApi().setEntityAPIData(InitApi.PLUGIN.getClass(), player.getUniqueId(), sxAttributeData);
        SXAttribute.getApi().updateStats(player);
    }

    /**
     * 移除玩家属性
     *
     * @param player 玩家
     */
    protected static void removeAttribute(Player player) {
        SXAttribute.getApi().removeEntityAPIData(InitApi.PLUGIN.getClass(), player.getUniqueId());
    }

}