/*
 * Decompiled with CFR 0.152.
 */
package cn.handyplus.lib.mm;

import io.lumine.xikage.mythicmobs.MythicMobs;
import io.lumine.xikage.mythicmobs.mobs.MythicMob;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MythicMobMiddleUtil {
    private static final MythicMobMiddleUtil INSTANCE = new MythicMobMiddleUtil();

    private MythicMobMiddleUtil() {
    }

    protected static MythicMobMiddleUtil getInstance() {
        return INSTANCE;
    }

    protected Map<String, String> getMythicMobMap(Integer pageNum, Integer pageSize) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List<MythicMob> mythicMobs = this.getMythicMobs(pageNum, pageSize);
        if (mythicMobs != null && !mythicMobs.isEmpty()) {
            for (MythicMob mythicMob : mythicMobs) {
                String displayName = mythicMob.getDisplayName() != null ? mythicMob.getDisplayName().get() : mythicMob.getInternalName();
                map.put(displayName, mythicMob.getInternalName());
            }
        }
        return map;
    }

    protected List<MythicMob> getMythicMobs(Integer pageNum, Integer pageSize) {
        Collection mythicMobs = MythicMobs.inst().getMobManager().getMobTypes();
        Stream limit = mythicMobs.stream().skip((long)pageNum.intValue() * (long)pageSize.intValue()).limit(pageSize.intValue());
        return limit.collect(Collectors.toList());
    }

    protected String getMythicMobName(String internalName) {
        MythicMob mythicMob = MythicMobs.inst().getMobManager().getMythicMob(internalName);
        if (mythicMob == null || mythicMob.getDisplayName() == null) {
            return internalName;
        }
        String mythicMobName = mythicMob.getDisplayName().get();
        if (mythicMobName == null || "".equals(mythicMobName)) {
            return internalName;
        }
        return mythicMobName;
    }

    protected Integer getMythicMobsCount() {
        Collection mythicMobs = MythicMobs.inst().getMobManager().getMobTypes();
        return mythicMobs.size();
    }

    protected boolean mobIsExist(String internalName) {
        MythicMob mythicMob = MythicMobs.inst().getMobManager().getMythicMob(internalName);
        return mythicMob != null;
    }
}

