/*
 * Decompiled with CFR 0.152.
 */
package cn.harveychan.canal.client.springboot.autoconfigure;

import cn.harveychan.canal.client.client.ClusterCanalClient;
import cn.harveychan.canal.client.factory.EntryColumnModelFactory;
import cn.harveychan.canal.client.factory.IModelFactory;
import cn.harveychan.canal.client.handler.EntryHandler;
import cn.harveychan.canal.client.handler.MessageHandler;
import cn.harveychan.canal.client.handler.RowDataHandler;
import cn.harveychan.canal.client.handler.impl.AsyncMessageHandlerImpl;
import cn.harveychan.canal.client.handler.impl.RowDataHandlerImpl;
import cn.harveychan.canal.client.handler.impl.SyncMessageHandlerImpl;
import cn.harveychan.canal.client.springboot.autoconfigure.ThreadPoolAutoConfiguration;
import cn.harveychan.canal.client.springboot.properties.CanalSimpleProperties;
import com.alibaba.otter.canal.protocol.CanalEntry;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={CanalSimpleProperties.class})
@ConditionalOnBean(value={EntryHandler.class})
@ConditionalOnProperty(value={"canal.mode"}, havingValue="cluster")
@Import(value={ThreadPoolAutoConfiguration.class})
public class ClusterClientAutoConfiguration {
    private CanalSimpleProperties canalSimpleProperties;

    public ClusterClientAutoConfiguration(CanalSimpleProperties canalSimpleProperties) {
        this.canalSimpleProperties = canalSimpleProperties;
    }

    @Bean
    public RowDataHandler<CanalEntry.RowData> rowDataHandler() {
        return new RowDataHandlerImpl((IModelFactory)new EntryColumnModelFactory());
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="true", matchIfMissing=true)
    public MessageHandler messageHandler(RowDataHandler<CanalEntry.RowData> rowDataHandler, List<EntryHandler> entryHandlers, ExecutorService executorService) {
        return new AsyncMessageHandlerImpl(entryHandlers, rowDataHandler, executorService);
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="false")
    public MessageHandler messageHandler(RowDataHandler<CanalEntry.RowData> rowDataHandler, List<EntryHandler> entryHandlers) {
        return new SyncMessageHandlerImpl(entryHandlers, rowDataHandler);
    }

    @Bean(initMethod="start", destroyMethod="stop")
    public ClusterCanalClient clusterCanalClient(MessageHandler messageHandler) {
        return ClusterCanalClient.builder().canalServers(this.canalSimpleProperties.getServer()).destination(this.canalSimpleProperties.getDestination()).userName(this.canalSimpleProperties.getUserName()).password(this.canalSimpleProperties.getPassword()).filter(this.canalSimpleProperties.getFilter()).batchSize(this.canalSimpleProperties.getBatchSize()).timeout(this.canalSimpleProperties.getTimeout()).unit(this.canalSimpleProperties.getUnit()).messageHandler(messageHandler).build();
    }
}

