/*
 * Decompiled with CFR 0.152.
 */
package cn.harveychan.canal.client.springboot.autoconfigure;

import cn.harveychan.canal.client.client.KafkaCanalClient;
import cn.harveychan.canal.client.factory.IModelFactory;
import cn.harveychan.canal.client.factory.MapColumnModelFactory;
import cn.harveychan.canal.client.handler.EntryHandler;
import cn.harveychan.canal.client.handler.MessageHandler;
import cn.harveychan.canal.client.handler.RowDataHandler;
import cn.harveychan.canal.client.handler.impl.AsyncFlatMessageHandlerImpl;
import cn.harveychan.canal.client.handler.impl.MapRowDataHandlerImpl;
import cn.harveychan.canal.client.handler.impl.SyncFlatMessageHandlerImpl;
import cn.harveychan.canal.client.springboot.autoconfigure.ThreadPoolAutoConfiguration;
import cn.harveychan.canal.client.springboot.properties.CanalKafkaProperties;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={CanalKafkaProperties.class})
@ConditionalOnBean(value={EntryHandler.class})
@ConditionalOnProperty(value={"canal.mode"}, havingValue="kafka")
@Import(value={ThreadPoolAutoConfiguration.class})
public class KafkaClientAutoConfiguration {
    private CanalKafkaProperties canalKafkaProperties;

    public KafkaClientAutoConfiguration(CanalKafkaProperties canalKafkaProperties) {
        this.canalKafkaProperties = canalKafkaProperties;
    }

    @Bean
    public RowDataHandler<List<Map<String, String>>> rowDataHandler() {
        return new MapRowDataHandlerImpl((IModelFactory)new MapColumnModelFactory());
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="true", matchIfMissing=true)
    public MessageHandler messageHandler(RowDataHandler<List<Map<String, String>>> rowDataHandler, List<EntryHandler> entryHandlers, ExecutorService executorService) {
        return new AsyncFlatMessageHandlerImpl(entryHandlers, rowDataHandler, executorService);
    }

    @Bean
    @ConditionalOnProperty(value={"canal.async"}, havingValue="false")
    public MessageHandler messageHandler(RowDataHandler<List<Map<String, String>>> rowDataHandler, List<EntryHandler> entryHandlers) {
        return new SyncFlatMessageHandlerImpl(entryHandlers, rowDataHandler);
    }

    public KafkaCanalClient kafkaCanalClient(MessageHandler messageHandler) {
        return KafkaCanalClient.builder().servers(this.canalKafkaProperties.getServer()).topic(this.canalKafkaProperties.getDestination()).groupId(this.canalKafkaProperties.getGroupId()).filter(this.canalKafkaProperties.getFilter()).batchSize(this.canalKafkaProperties.getBatchSize()).timeout(this.canalKafkaProperties.getTimeout()).unit(this.canalKafkaProperties.getUnit()).messageHandler(messageHandler).build();
    }
}

