/*
 * Decompiled with CFR 0.152.
 */
package cn.harveychan.canal.client.springboot.autoconfigure;

import cn.harveychan.canal.client.handler.CanalThreadUncaughtExceptionHandler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.apache.commons.lang3.concurrent.BasicThreadFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"canal.async"}, havingValue="true", matchIfMissing=true)
public class ThreadPoolAutoConfiguration {
    @Bean(destroyMethod="shutdown")
    public ExecutorService executorService() {
        BasicThreadFactory factory = new BasicThreadFactory.Builder().namingPattern("canal-execute-thread-%d").uncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new CanalThreadUncaughtExceptionHandler()).build();
        return Executors.newFixedThreadPool(20, (ThreadFactory)factory);
    }
}

