/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.consistency.serialize;

import com.alibaba.nacos.common.utils.ByteUtils;
import com.alibaba.nacos.consistency.Serializer;
import com.caucho.hessian.io.Hessian2Input;
import com.caucho.hessian.io.Hessian2Output;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;

public class HessianSerializer
implements Serializer {
    private SerializerFactory serializerFactory = new SerializerFactory();

    @Override
    public <T> T deserialize(byte[] data) {
        return this.deseiralize0(data);
    }

    @Override
    public <T> T deserialize(byte[] data, Class<T> cls) {
        return this.deserialize(data);
    }

    @Override
    public <T> T deserialize(byte[] data, Type type) {
        return this.deserialize(data);
    }

    private <T> T deseiralize0(byte[] data) {
        Object resultObject;
        if (ByteUtils.isEmpty((byte[])data)) {
            return null;
        }
        Hessian2Input input = new Hessian2Input((InputStream)new ByteArrayInputStream(data));
        input.setSerializerFactory(this.serializerFactory);
        try {
            resultObject = input.readObject();
            input.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred when Hessian serializer decode!", e);
        }
        return (T)resultObject;
    }

    @Override
    public <T> byte[] serialize(T obj) {
        ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
        Hessian2Output output = new Hessian2Output((OutputStream)byteArray);
        output.setSerializerFactory(this.serializerFactory);
        try {
            output.writeObject(obj);
            output.close();
        }
        catch (IOException e) {
            throw new RuntimeException("IOException occurred when Hessian serializer encode!", e);
        }
        return byteArray.toByteArray();
    }

    @Override
    public String name() {
        return "Hessian";
    }
}

