/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.pay.wechat.definition;

import cn.herodotus.engine.pay.core.exception.PaymentProfileIdIncorrectException;
import cn.herodotus.engine.pay.core.exception.PaymentProfileNotFoundException;
import cn.herodotus.engine.pay.wechat.definition.WxpayPaymentExecuter;
import cn.herodotus.engine.pay.wechat.definition.WxpayProfile;
import cn.herodotus.engine.pay.wechat.definition.WxpayProfileStorage;
import cn.herodotus.engine.pay.wechat.properties.WxpayProperties;
import com.github.binarywang.wxpay.config.WxPayConfig;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.service.impl.WxPayServiceImpl;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxpayPaymentTemplate {
    private static final Logger log = LoggerFactory.getLogger(WxpayPaymentTemplate.class);
    private final WxpayProfileStorage wxpayProfileStorage;
    private final WxpayProperties wxpayProperties;

    public WxpayPaymentTemplate(WxpayProfileStorage wxpayProfileStorage, WxpayProperties wxpayProperties) {
        this.wxpayProfileStorage = wxpayProfileStorage;
        this.wxpayProperties = wxpayProperties;
    }

    private WxpayProfileStorage getWxpayProfileStorage() {
        return this.wxpayProfileStorage;
    }

    private WxpayProperties getWxpayProperties() {
        return this.wxpayProperties;
    }

    private WxpayProfile getProfile(String identity) {
        WxpayProfile wxpayProfile = this.getWxpayProfileStorage().getProfile(identity);
        if (ObjectUtils.isNotEmpty((Object)wxpayProfile)) {
            return wxpayProfile;
        }
        throw new PaymentProfileNotFoundException("Payment profile for " + identity + " not found.");
    }

    private WxpayPaymentExecuter getProcessor(Boolean sandbox, WxpayProfile wxpayProfile) {
        WxPayConfig payConfig = new WxPayConfig();
        payConfig.setAppId(wxpayProfile.getAppId());
        payConfig.setMchId(wxpayProfile.getMchId());
        payConfig.setMchKey(wxpayProfile.getMchKey());
        payConfig.setSubAppId(wxpayProfile.getSubAppId());
        payConfig.setSubMchId(wxpayProfile.getSubMchId());
        payConfig.setKeyPath(wxpayProfile.getKeyPath());
        payConfig.setUseSandboxEnv(sandbox.booleanValue());
        WxPayServiceImpl wxPayService = new WxPayServiceImpl();
        wxPayService.setConfig(payConfig);
        return new WxpayPaymentExecuter((WxPayService)wxPayService);
    }

    public WxpayPaymentExecuter getProcessor(String identity) {
        String id;
        String string = id = StringUtils.isNotBlank((CharSequence)identity) ? identity : this.getWxpayProperties().getDefaultProfile();
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new PaymentProfileIdIncorrectException("Payment profile incorrect, or try to set default profile id.");
        }
        WxpayProfile wxpayProfile = this.getProfile(identity);
        return this.getProcessor(this.getWxpayProperties().getSandbox(), wxpayProfile);
    }
}

