/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.pay.wechat.configuration;

import cn.herodotus.engine.pay.wechat.annotation.ConditionalOnWxpay;
import cn.herodotus.engine.pay.wechat.definition.WxpayPaymentTemplate;
import cn.herodotus.engine.pay.wechat.definition.WxpayProfileStorage;
import cn.herodotus.engine.pay.wechat.properties.WxpayProperties;
import cn.herodotus.engine.pay.wechat.support.WxpayDefaultProfileStorage;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWxpay
@EnableConfigurationProperties(value={WxpayProperties.class})
public class WxpayConfiguration {
    private static final Logger log = LoggerFactory.getLogger(WxpayConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Engine Pay Wxpay] Auto Configure.");
    }

    @Bean
    @ConditionalOnMissingBean
    public WxpayProfileStorage wxpayDefaultProfileStorage(WxpayProperties wxpayProperties) {
        WxpayDefaultProfileStorage wxpayDefaultProfileStorage = new WxpayDefaultProfileStorage(wxpayProperties);
        log.debug("[Herodotus] |- Bean [Wxpay Default Profile Storage] Auto Configure.");
        return wxpayDefaultProfileStorage;
    }

    @Bean
    @ConditionalOnMissingBean
    public WxpayPaymentTemplate wxpayPaymentTemplate(WxpayProfileStorage wxpayProfileStorage, WxpayProperties wxpayProperties) {
        WxpayPaymentTemplate wxpayPaymentTemplate = new WxpayPaymentTemplate(wxpayProfileStorage, wxpayProperties);
        log.trace("[Herodotus] |- Bean [Wxpay Payment Template] Auto Configure.");
        return wxpayPaymentTemplate;
    }
}

