/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.chinamobile.configuration;

import cn.herodotus.engine.sms.chinamobile.annotation.ConditionalOnChinaMobileSmsEnabled;
import cn.herodotus.engine.sms.chinamobile.processor.ChinaMobileSmsSendHandler;
import cn.herodotus.engine.sms.chinamobile.properties.ChinaMobileSmsProperties;
import jakarta.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnChinaMobileSmsEnabled
@EnableConfigurationProperties(value={ChinaMobileSmsProperties.class})
public class ChinaMobileSmsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ChinaMobileSmsConfiguration.class);

    @PostConstruct
    public void postConstruct() {
        log.debug("[Herodotus] |- SDK [Engine Sms China Mobile] Auto Configure.");
    }

    @Bean(name={"CHINA_MOBILE"})
    public ChinaMobileSmsSendHandler chinaMobileSmsSendHandler(ChinaMobileSmsProperties chinaMobileSmsProperties) {
        ChinaMobileSmsSendHandler chinaMobileSmsSendHandler = new ChinaMobileSmsSendHandler(chinaMobileSmsProperties);
        log.debug("[Herodotus] |- Bean [China Mobile Sms Send Handler] Auto Configure.");
        return chinaMobileSmsSendHandler;
    }
}

