/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.huawei.processor;

import cn.herodotus.engine.sms.core.definition.AbstractSmsSendHandler;
import cn.herodotus.engine.sms.core.definition.SmsProperties;
import cn.herodotus.engine.sms.core.domain.Template;
import cn.herodotus.engine.sms.core.enums.SmsSupplier;
import cn.herodotus.engine.sms.core.exception.ParameterOrdersInvalidException;
import cn.herodotus.engine.sms.core.exception.TemplateIdInvalidException;
import cn.herodotus.engine.sms.huawei.domain.HuaweiSmsRequest;
import cn.herodotus.engine.sms.huawei.domain.HuaweiSmsResponse;
import cn.herodotus.engine.sms.huawei.properties.HuaweiSmsProperties;
import cn.zhxu.okhttps.HttpResult;
import cn.zhxu.okhttps.SHttpTask;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuaweiSmsSendHandler
extends AbstractSmsSendHandler {
    private static final Logger log = LoggerFactory.getLogger(HuaweiSmsSendHandler.class);
    private static final String WSSE_HEADER_FORMAT = "UsernameToken Username=\"%s\",PasswordDigest=\"%s\",Nonce=\"%s\",Created=\"%s\"";
    private static final String AUTH_HEADER_VALUE = "WSSE realm=\"SDP\",profile=\"UsernameToken\",type=\"Appkey\"";
    private final HuaweiSmsProperties properties;

    public HuaweiSmsSendHandler(HuaweiSmsProperties properties) {
        super((SmsProperties)properties);
        this.properties = properties;
    }

    private CloseableHttpClient buildHttpclient() {
        try {
            TrustStrategy trustStrategy = (x509CertChain, authType) -> true;
            SSLContext sslContext = new SSLContextBuilder().loadTrustMaterial(trustStrategy).build();
            return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)NoopHostnameVerifier.INSTANCE).build();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    private String buildWsseHeader() {
        String appKey = this.properties.getAppKey();
        String appSecret = this.properties.getAppSecret();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        String time = sdf.format(new Date());
        String nonce = UUID.randomUUID().toString().replace("-", "");
        byte[] passwordDigest = DigestUtils.sha256((String)(nonce + time + appSecret));
        String hexDigest = Hex.encodeHexString((byte[])passwordDigest);
        String passwordDigestBase64Str = Base64.getEncoder().encodeToString(hexDigest.getBytes());
        return String.format(WSSE_HEADER_FORMAT, appKey, passwordDigestBase64Str, nonce, time);
    }

    protected String getChannel() {
        return SmsSupplier.HUAWEI_CLOUD.name();
    }

    protected boolean execute(Template template, List<String> phones) throws TemplateIdInvalidException, ParameterOrdersInvalidException {
        HuaweiSmsResponse huaweiSmsResponse;
        String templateId = this.getTemplateId(template);
        String mobiles = this.wellFormed(phones);
        String templateParams = this.getOrderedParamsString(template);
        String wsseHeader = this.buildWsseHeader();
        HuaweiSmsRequest request = new HuaweiSmsRequest();
        request.setFrom(this.properties.getSender());
        request.setTo(mobiles);
        request.setTemplateId(templateId);
        request.setTemplateParas(templateParams);
        request.setSignature(this.properties.getSignature());
        HttpResult result = ((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)((SHttpTask)this.http().sync(this.properties.getUri()).bodyType("json")).addHeader("Authorization", AUTH_HEADER_VALUE)).addHeader("X-WSSE", wsseHeader)).setBodyPara((Object)request)).nothrow()).post();
        return result.isSuccessful() && ObjectUtils.isNotEmpty((Object)(huaweiSmsResponse = (HuaweiSmsResponse)result.getBody().toBean(HuaweiSmsResponse.class))) && "000000".equals(huaweiSmsResponse.getCode());
    }
}

