/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.engine.sms.yunpian.processor;

import cn.herodotus.engine.sms.core.definition.AbstractSmsSendHandler;
import cn.herodotus.engine.sms.core.definition.SmsProperties;
import cn.herodotus.engine.sms.core.domain.Template;
import cn.herodotus.engine.sms.core.enums.SmsSupplier;
import cn.herodotus.engine.sms.core.exception.ParameterOrdersInvalidException;
import cn.herodotus.engine.sms.core.exception.TemplateIdInvalidException;
import cn.herodotus.engine.sms.yunpian.properties.YunpianSmsProperties;
import com.yunpian.sdk.YunpianClient;
import com.yunpian.sdk.model.Result;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YunpianSmsSendHandler
extends AbstractSmsSendHandler {
    private static final Logger log = LoggerFactory.getLogger(YunpianSmsSendHandler.class);
    private final YunpianClient client;
    private final YunpianSmsProperties properties;

    public YunpianSmsSendHandler(YunpianSmsProperties properties) {
        super((SmsProperties)properties);
        this.properties = properties;
        this.client = new YunpianClient(properties.getApikey()).init();
    }

    protected String getChannel() {
        return SmsSupplier.YUNPIAN.name();
    }

    protected boolean execute(Template template, List<String> phones) throws TemplateIdInvalidException, ParameterOrdersInvalidException {
        Map params = template.getParams();
        ArrayList list = new ArrayList();
        if (MapUtils.isNotEmpty((Map)params)) {
            params.forEach((key, value) -> list.add(this.encode((String)key, (String)value)));
        }
        String templateParams = this.join(list, "&");
        String mobile = this.join(phones);
        HashMap<String, String> data = new HashMap<String, String>(8);
        data.put("apikey", this.properties.getApikey());
        data.put("mobile", mobile);
        data.put("tpl_id", this.getTemplateId(template));
        data.put("tpl_value", templateParams);
        Result result = StringUtils.contains((CharSequence)mobile, (CharSequence)",") ? this.client.sms().batch_send(data) : this.client.sms().single_send(data);
        return Objects.equals(result.getCode(), 0);
    }

    private String encode(String key, String value) {
        String prefix = this.encode("#" + key + "#");
        String suffix = this.encode(value);
        return prefix + "=" + suffix;
    }

    private String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }
}

