/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONObject;
import com.xkcoding.http.support.HttpHeader;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.enums.scope.AuthSlackScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.TokenUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthSlackRequest
extends AuthDefaultRequest {
    public AuthSlackRequest(AuthConfig config) {
        super(config, AuthDefaultSource.SLACK);
    }

    public AuthSlackRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.SLACK, authStateCache);
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        HttpHeader header = new HttpHeader().add("Content-Type", "application/x-www-form-urlencoded");
        String response = new HttpUtils(this.config.getHttpConfig()).get(this.accessTokenUrl(authCallback.getCode()), null, header, false).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).scope(accessTokenObject.getString("scope")).tokenType(accessTokenObject.getString("token_type")).uid(accessTokenObject.getJSONObject("authed_user").getString("id")).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        HttpHeader header = new HttpHeader().add("Content-Type", "application/x-www-form-urlencoded").add("Authorization", TokenUtils.bearer(authToken.getAccessToken()));
        String userInfo = new HttpUtils(this.config.getHttpConfig()).get(this.userInfoUrl(authToken), null, header, false).getBody();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        this.checkResponse(object);
        JSONObject user = object.getJSONObject("user");
        JSONObject profile = user.getJSONObject("profile");
        return AuthUser.builder().rawUserInfo(user).uuid(user.getString("id")).username(user.getString("name")).nickname(user.getString("real_name")).avatar(profile.getString("image_original")).email(profile.getString("email")).gender(AuthUserGender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse revoke(AuthToken authToken) {
        HttpHeader header = new HttpHeader().add("Content-Type", "application/x-www-form-urlencoded").add("Authorization", TokenUtils.bearer(authToken.getAccessToken()));
        String userInfo = new HttpUtils(this.config.getHttpConfig()).get(this.source.revoke(), null, header, false).getBody();
        JSONObject object = JSONObject.parseObject((String)userInfo);
        this.checkResponse(object);
        AuthResponseStatus status = object.getBooleanValue("revoked") ? AuthResponseStatus.SUCCESS : AuthResponseStatus.FAILURE;
        return AuthResponse.builder().code(status.getCode()).msg(status.getMsg()).build();
    }

    private void checkResponse(JSONObject object) {
        if (!object.getBooleanValue("ok")) {
            JSONArray array;
            Object errorMsg = object.getString("error");
            if (object.containsKey("response_metadata") && null != (array = object.getJSONObject("response_metadata").getJSONArray("messages")) && array.size() > 0) {
                errorMsg = (String)errorMsg + "; " + String.join((CharSequence)",", (CharSequence[])array.toArray((Object[])new String[0]));
            }
            throw new AuthException((String)errorMsg);
        }
    }

    @Override
    public String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("user", authToken.getUid()).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("client_id", this.config.getClientId()).queryParam("state", this.getRealState(state)).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("scope", this.getScopes(",", true, AuthScopeUtils.getDefaultScopes(AuthSlackScope.values()))).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.config.getClientId()).queryParam("client_secret", this.config.getClientSecret()).queryParam("redirect_uri", this.config.getRedirectUri()).build();
    }
}

