/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson2.JSONObject;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.impl.security.AbstractJwk;
import io.jsonwebtoken.lang.NestedCollection;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Base64;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.scope.AuthAppleScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;

public class AuthAppleRequest
extends AuthDefaultRequest {
    private static final String AUD = "https://appleid.apple.com";
    private volatile PrivateKey privateKey;

    public AuthAppleRequest(AuthConfig config) {
        super(config, AuthDefaultSource.APPLE);
    }

    public AuthAppleRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.APPLE, authStateCache);
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("response_mode", "form_post").queryParam("scope", this.getScopes(" ", false, AuthScopeUtils.getDefaultScopes(AuthAppleScope.values()))).build();
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        if (!StringUtils.isEmpty(authCallback.getError())) {
            throw new AuthException(authCallback.getError());
        }
        this.config.setClientSecret(this.getToken());
        String response = this.doPostAuthorizationCode(authCallback.getCode());
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        AuthToken.AuthTokenBuilder builder = AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).refreshToken(accessTokenObject.getString("refresh_token")).tokenType(accessTokenObject.getString("token_type")).idToken(accessTokenObject.getString("id_token"));
        if (!StringUtils.isEmpty(authCallback.getUser())) {
            try {
                AppleUserInfo userInfo = (AppleUserInfo)JSONObject.parseObject((String)authCallback.getUser(), AppleUserInfo.class);
                builder.username(userInfo.getName().getFirstName() + " " + userInfo.getName().getLastName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return builder.build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        Base64.Decoder urlDecoder = Base64.getUrlDecoder();
        String[] idToken = authToken.getIdToken().split("\\.");
        String payload = new String(urlDecoder.decode(idToken[1]));
        JSONObject object = JSONObject.parseObject((String)payload);
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("sub")).email(object.getString("email")).username(authToken.getUsername()).token(authToken).source(this.source.toString()).build();
    }

    @Override
    protected void checkConfig(AuthConfig config) {
        super.checkConfig(config);
        if (StringUtils.isEmpty(config.getClientId())) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_CLIENT_ID, this.source);
        }
        if (StringUtils.isEmpty(config.getClientSecret())) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_CLIENT_SECRET, this.source);
        }
        if (StringUtils.isEmpty(config.getKid())) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_KID, this.source);
        }
        if (StringUtils.isEmpty(config.getTeamId())) {
            throw new AuthException(AuthResponseStatus.ILLEGAL_TEAM_ID, this.source);
        }
    }

    private String getToken() {
        return ((JwtBuilder)((NestedCollection)((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().header().add((Object)AbstractJwk.KID.getId(), (Object)this.config.getKid())).and()).issuer(this.config.getTeamId()).subject(this.config.getClientId()).audience().add((Object)AUD)).and()).expiration(new Date(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(3L))).issuedAt(new Date()).signWith((Key)this.getPrivateKey()).compact();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey getPrivateKey() {
        if (this.privateKey == null) {
            AuthAppleRequest authAppleRequest = this;
            synchronized (authAppleRequest) {
                if (this.privateKey == null) {
                    try (PEMParser pemParser = new PEMParser((Reader)new StringReader(this.config.getClientSecret()));){
                        JcaPEMKeyConverter pemKeyConverter = new JcaPEMKeyConverter();
                        PrivateKeyInfo keyInfo = (PrivateKeyInfo)pemParser.readObject();
                        this.privateKey = pemKeyConverter.getPrivateKey(keyInfo);
                    }
                    catch (IOException e) {
                        throw new AuthException("Failed to get apple private key", e);
                    }
                }
            }
        }
        return this.privateKey;
    }

    static class AppleUserInfo {
        private AppleUsername name;
        private String email;

        @Generated
        public AppleUserInfo() {
        }

        @Generated
        public AppleUsername getName() {
            return this.name;
        }

        @Generated
        public String getEmail() {
            return this.email;
        }

        @Generated
        public void setName(AppleUsername name) {
            this.name = name;
        }

        @Generated
        public void setEmail(String email) {
            this.email = email;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppleUserInfo)) {
                return false;
            }
            AppleUserInfo other = (AppleUserInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AppleUsername this$name = this.getName();
            AppleUsername other$name = other.getName();
            if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
                return false;
            }
            String this$email = this.getEmail();
            String other$email = other.getEmail();
            return !(this$email == null ? other$email != null : !this$email.equals(other$email));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppleUserInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AppleUsername $name = this.getName();
            result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
            String $email = this.getEmail();
            result = result * 59 + ($email == null ? 43 : $email.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthAppleRequest.AppleUserInfo(name=" + String.valueOf(this.getName()) + ", email=" + this.getEmail() + ")";
        }
    }

    static class AppleUsername {
        private String firstName;
        private String lastName;

        @Generated
        public AppleUsername() {
        }

        @Generated
        public String getFirstName() {
            return this.firstName;
        }

        @Generated
        public String getLastName() {
            return this.lastName;
        }

        @Generated
        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Generated
        public void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AppleUsername)) {
                return false;
            }
            AppleUsername other = (AppleUsername)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$firstName = this.getFirstName();
            String other$firstName = other.getFirstName();
            if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
                return false;
            }
            String this$lastName = this.getLastName();
            String other$lastName = other.getLastName();
            return !(this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof AppleUsername;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $firstName = this.getFirstName();
            result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
            String $lastName = this.getLastName();
            result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthAppleRequest.AppleUsername(firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ")";
        }
    }
}

