/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson2.JSONObject;
import java.util.Objects;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.enums.scope.AuthPinterestScope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthPinterestRequest
extends AuthDefaultRequest {
    private static final String FAILURE = "failure";

    public AuthPinterestRequest(AuthConfig config) {
        super(config, AuthDefaultSource.PINTEREST);
    }

    public AuthPinterestRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.PINTEREST, authStateCache);
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        String response = this.doPostAuthorizationCode(authCallback.getCode());
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).tokenType(accessTokenObject.getString("token_type")).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        String userinfoUrl = this.userInfoUrl(authToken);
        String response = new HttpUtils(this.config.getHttpConfig()).get(userinfoUrl).getBody();
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        JSONObject userObj = object.getJSONObject("data");
        return AuthUser.builder().rawUserInfo(userObj).uuid(userObj.getString("id")).avatar(this.getAvatarUrl(userObj)).username(userObj.getString("username")).nickname(userObj.getString("first_name") + " " + userObj.getString("last_name")).gender(AuthUserGender.UNKNOWN).remark(userObj.getString("bio")).token(authToken).source(this.source.toString()).build();
    }

    private String getAvatarUrl(JSONObject userObj) {
        JSONObject jsonObject = userObj.getJSONObject("image");
        if (Objects.isNull(jsonObject)) {
            return null;
        }
        return jsonObject.getJSONObject("60x60").getString("url");
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, AuthScopeUtils.getDefaultScopes(AuthPinterestScope.values()))).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("access_token", authToken.getAccessToken()).queryParam("fields", "id,username,first_name,last_name,bio,image").build();
    }

    private void checkResponse(JSONObject object) {
        if (!object.containsKey("status") && FAILURE.equals(object.getString("status"))) {
            throw new AuthException(object.getString("message"));
        }
    }
}

