/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson2.JSONObject;
import com.xkcoding.http.HttpUtil;
import java.util.HashMap;
import java.util.Optional;
import java.util.TreeMap;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthXmlyRequest
extends AuthDefaultRequest {
    public AuthXmlyRequest(AuthConfig config) {
        super(config, AuthDefaultSource.XMLY);
    }

    public AuthXmlyRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.XMLY, authStateCache);
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> map = new HashMap<String, String>(9);
        map.put("code", authCallback.getCode());
        map.put("client_id", this.config.getClientId());
        map.put("client_secret", this.config.getClientSecret());
        map.put("device_id", this.config.getDeviceId());
        map.put("grant_type", "authorization_code");
        map.put("redirect_uri", this.config.getRedirectUri());
        String response = HttpUtil.post((String)this.source.accessToken(), map, (boolean)true).getBody();
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().accessToken(accessTokenObject.getString("access_token")).refreshToken(accessTokenObject.getString("refresh_token")).expireIn(accessTokenObject.getIntValue("expires_in")).uid(accessTokenObject.getString("uid")).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("client_id", this.config.getClientId()).queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).queryParam("client_os_type", "3").queryParam("device_id", this.config.getDeviceId()).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("app_key", this.config.getClientId());
        map.put("client_os_type", Optional.ofNullable(this.config.getClientOsType()).orElse(3).toString());
        map.put("device_id", this.config.getDeviceId());
        map.put("pack_id", this.config.getPackId());
        map.put("access_token", authToken.getAccessToken());
        map.put("sig", GlobalAuthUtils.generateXmlySignature(map, this.config.getClientSecret()));
        String rawUserInfo = HttpUtil.get((String)this.source.userInfo(), map, (boolean)false).getBody();
        JSONObject object = JSONObject.parseObject((String)rawUserInfo);
        this.checkResponse(object);
        return AuthUser.builder().uuid(object.getString("id")).nickname(object.getString("nickname")).avatar(object.getString("avatar_url")).rawUserInfo(object).source(this.source.toString()).token(authToken).gender(AuthUserGender.UNKNOWN).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey("errcode")) {
            throw new AuthException(object.getIntValue("error_no"), object.getString("error_desc"));
        }
    }
}

