/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthSource;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public abstract class AbstractAuthDingtalkRequest
extends AuthDefaultRequest {
    public AbstractAuthDingtalkRequest(AuthConfig config, AuthSource source) {
        super(config, source);
    }

    public AbstractAuthDingtalkRequest(AuthConfig config, AuthSource source, AuthStateCache authStateCache) {
        super(config, source, authStateCache);
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        return AuthToken.builder().accessCode(authCallback.getCode()).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        String code = authToken.getAccessCode();
        JSONObject param = new JSONObject();
        param.put((Object)"tmp_auth_code", (Object)code);
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.userInfoUrl(authToken), param.toJSONString(new JSONWriter.Feature[0])).getBody();
        JSONObject object = JSON.parseObject((String)response);
        if (object.getIntValue("errcode") != 0) {
            throw new AuthException(object.getString("errmsg"));
        }
        object = object.getJSONObject("user_info");
        AuthToken token = AuthToken.builder().openId(object.getString("openid")).unionId(object.getString("unionid")).build();
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("unionid")).nickname(object.getString("nick")).username(object.getString("nick")).gender(AuthUserGender.UNKNOWN).source(this.source.toString()).token(token).build();
    }

    @Override
    public String authorize(String state) {
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("response_type", "code").queryParam("appid", this.config.getClientId()).queryParam("scope", "snsapi_login").queryParam("redirect_uri", this.config.getRedirectUri()).queryParam("state", this.getRealState(state)).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        String timestamp = "" + System.currentTimeMillis();
        String urlEncodeSignature = GlobalAuthUtils.generateDingTalkSignature(this.config.getClientSecret(), timestamp);
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("signature", urlEncodeSignature).queryParam("timestamp", timestamp).queryParam("accessKey", this.config.getClientId()).build();
    }
}

