/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson2.JSONObject;
import com.xkcoding.http.support.HttpHeader;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.enums.AuthResponseStatus;
import me.zhyd.oauth.enums.AuthUserGender;
import me.zhyd.oauth.enums.scope.AuthHuaweiV3Scope;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthResponse;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.AuthScopeUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.PkceUtil;
import me.zhyd.oauth.utils.StringUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthHuaweiV3Request
extends AuthDefaultRequest {
    public AuthHuaweiV3Request(AuthConfig config) {
        super(config, AuthDefaultSource.HUAWEI_V3);
    }

    public AuthHuaweiV3Request(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.HUAWEI_V3, authStateCache);
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        HashMap<String, String> form = new HashMap<String, String>(8);
        form.put("grant_type", "authorization_code");
        form.put("code", authCallback.getCode());
        form.put("client_id", this.config.getClientId());
        form.put("client_secret", this.config.getClientSecret());
        form.put("redirect_uri", this.config.getRedirectUri());
        if (this.config.isPkce()) {
            String cacheKey = this.source.getName().concat(":code_verifier:").concat(authCallback.getState());
            String codeVerifier = this.authStateCache.get(cacheKey);
            form.put("code_verifier", codeVerifier);
        }
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Content-Type", "application/x-www-form-urlencoded");
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), form, httpHeader, false).getBody();
        return this.getAuthToken(response);
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        String idToken = authToken.getIdToken();
        if (StringUtils.isEmpty(idToken)) {
            HashMap<String, String> form = new HashMap<String, String>(7);
            form.put("access_token", authToken.getAccessToken());
            form.put("getNickName", "1");
            form.put("nsp_svc", "GOpen.User.getInfo");
            HttpHeader httpHeader = new HttpHeader();
            httpHeader.add("Content-Type", "application/x-www-form-urlencoded");
            String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.userInfo(), form, httpHeader, false).getBody();
            JSONObject object = JSONObject.parseObject((String)response);
            this.checkResponse(object);
            return AuthUser.builder().rawUserInfo(object).uuid(object.getString("unionID")).username(object.getString("displayName")).nickname(object.getString("displayName")).gender(AuthUserGender.UNKNOWN).avatar(object.getString("headPictureURL")).token(authToken).source(this.source.toString()).build();
        }
        String payload = new String(Base64.getUrlDecoder().decode(idToken.split("\\.")[1]), StandardCharsets.UTF_8);
        JSONObject object = JSONObject.parseObject((String)payload);
        return AuthUser.builder().rawUserInfo(object).uuid(object.getString("sub")).username(object.getString("name")).nickname(object.getString("nickname")).gender(AuthUserGender.UNKNOWN).avatar(object.getString("picture")).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public AuthResponse<AuthToken> refresh(AuthToken authToken) {
        HashMap<String, String> form = new HashMap<String, String>(7);
        form.put("client_id", this.config.getClientId());
        form.put("client_secret", this.config.getClientSecret());
        form.put("refresh_token", authToken.getRefreshToken());
        form.put("grant_type", "refresh_token");
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Content-Type", "application/x-www-form-urlencoded");
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.refresh(), form, httpHeader, false).getBody();
        return AuthResponse.builder().code(AuthResponseStatus.SUCCESS.getCode()).data(this.getAuthToken(response)).build();
    }

    private AuthToken getAuthToken(String response) {
        JSONObject object = JSONObject.parseObject((String)response);
        this.checkResponse(object);
        return AuthToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).refreshToken(object.getString("refresh_token")).idToken(object.getString("id_token")).build();
    }

    @Override
    public String authorize(String state) {
        String realState = this.getRealState(state);
        UrlBuilder builder = UrlBuilder.fromBaseUrl(super.authorize(realState)).queryParam("access_type", "offline").queryParam("scope", this.getScopes(" ", true, AuthScopeUtils.getDefaultScopes(AuthHuaweiV3Scope.values())));
        if (this.config.isPkce()) {
            String cacheKey = this.source.getName().concat(":code_verifier:").concat(realState);
            String codeVerifier = PkceUtil.generateCodeVerifier();
            String codeChallengeMethod = "S256";
            String codeChallenge = PkceUtil.generateCodeChallenge(codeChallengeMethod, codeVerifier);
            builder.queryParam("code_challenge", codeChallenge).queryParam("code_challenge_method", codeChallengeMethod);
            this.authStateCache.cache(cacheKey, codeVerifier, TimeUnit.MINUTES.toMillis(10L));
        }
        return builder.build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey("NSP_STATUS")) {
            throw new AuthException(object.getString("error"));
        }
        if (object.containsKey("error")) {
            throw new AuthException(object.getString("sub_error") + ":" + object.getString("error_description"));
        }
    }
}

