/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.annotation.JSONField;
import lombok.Generated;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.exception.AuthException;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthQQMiniProgramRequest
extends AuthDefaultRequest {
    public AuthQQMiniProgramRequest(AuthConfig config) {
        super(config, AuthDefaultSource.QQ_MINI_PROGRAM);
    }

    public AuthQQMiniProgramRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.QQ_MINI_PROGRAM, authStateCache);
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        String response = new HttpUtils(this.config.getHttpConfig()).get(this.accessTokenUrl(authCallback.getCode())).getBody();
        JSCode2SessionResponse accessTokenObject = (JSCode2SessionResponse)JSONObject.parseObject((String)response, JSCode2SessionResponse.class);
        assert (accessTokenObject != null);
        this.checkResponse(accessTokenObject);
        return AuthToken.builder().openId(accessTokenObject.getOpenid()).unionId(accessTokenObject.getUnionId()).accessToken(accessTokenObject.getSessionKey()).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        return AuthUser.builder().username("").nickname("").avatar("").uuid(authToken.getOpenId()).token(authToken).source(this.source.toString()).build();
    }

    private void checkResponse(JSCode2SessionResponse response) {
        if (response.getErrorCode() != 0) {
            throw new AuthException(response.getErrorCode(), response.getErrorMsg());
        }
    }

    @Override
    protected String accessTokenUrl(String code) {
        return UrlBuilder.fromBaseUrl(this.source.accessToken()).queryParam("appid", this.config.getClientId()).queryParam("secret", this.config.getClientSecret()).queryParam("js_code", code).queryParam("grant_type", "authorization_code").build();
    }

    private static class JSCode2SessionResponse {
        @JSONField(name="errcode")
        private int errorCode;
        @JSONField(name="errmsg")
        private String errorMsg;
        @JSONField(name="session_key")
        private String sessionKey;
        private String openid;
        @JSONField(name="unionid")
        private String unionId;

        @Generated
        public JSCode2SessionResponse() {
        }

        @Generated
        public int getErrorCode() {
            return this.errorCode;
        }

        @Generated
        public String getErrorMsg() {
            return this.errorMsg;
        }

        @Generated
        public String getSessionKey() {
            return this.sessionKey;
        }

        @Generated
        public String getOpenid() {
            return this.openid;
        }

        @Generated
        public String getUnionId() {
            return this.unionId;
        }

        @Generated
        public void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        @Generated
        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        @Generated
        public void setSessionKey(String sessionKey) {
            this.sessionKey = sessionKey;
        }

        @Generated
        public void setOpenid(String openid) {
            this.openid = openid;
        }

        @Generated
        public void setUnionId(String unionId) {
            this.unionId = unionId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof JSCode2SessionResponse)) {
                return false;
            }
            JSCode2SessionResponse other = (JSCode2SessionResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getErrorCode() != other.getErrorCode()) {
                return false;
            }
            String this$errorMsg = this.getErrorMsg();
            String other$errorMsg = other.getErrorMsg();
            if (this$errorMsg == null ? other$errorMsg != null : !this$errorMsg.equals(other$errorMsg)) {
                return false;
            }
            String this$sessionKey = this.getSessionKey();
            String other$sessionKey = other.getSessionKey();
            if (this$sessionKey == null ? other$sessionKey != null : !this$sessionKey.equals(other$sessionKey)) {
                return false;
            }
            String this$openid = this.getOpenid();
            String other$openid = other.getOpenid();
            if (this$openid == null ? other$openid != null : !this$openid.equals(other$openid)) {
                return false;
            }
            String this$unionId = this.getUnionId();
            String other$unionId = other.getUnionId();
            return !(this$unionId == null ? other$unionId != null : !this$unionId.equals(other$unionId));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof JSCode2SessionResponse;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getErrorCode();
            String $errorMsg = this.getErrorMsg();
            result = result * 59 + ($errorMsg == null ? 43 : $errorMsg.hashCode());
            String $sessionKey = this.getSessionKey();
            result = result * 59 + ($sessionKey == null ? 43 : $sessionKey.hashCode());
            String $openid = this.getOpenid();
            result = result * 59 + ($openid == null ? 43 : $openid.hashCode());
            String $unionId = this.getUnionId();
            result = result * 59 + ($unionId == null ? 43 : $unionId.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuthQQMiniProgramRequest.JSCode2SessionResponse(errorCode=" + this.getErrorCode() + ", errorMsg=" + this.getErrorMsg() + ", sessionKey=" + this.getSessionKey() + ", openid=" + this.getOpenid() + ", unionId=" + this.getUnionId() + ")";
        }
    }
}

