/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.request;

import com.alibaba.fastjson2.JSONObject;
import com.xkcoding.http.support.HttpHeader;
import com.xkcoding.http.util.MapUtil;
import java.util.HashMap;
import java.util.Map;
import me.zhyd.oauth.cache.AuthStateCache;
import me.zhyd.oauth.config.AuthConfig;
import me.zhyd.oauth.config.AuthDefaultSource;
import me.zhyd.oauth.model.AuthCallback;
import me.zhyd.oauth.model.AuthToken;
import me.zhyd.oauth.model.AuthUser;
import me.zhyd.oauth.request.AuthDefaultRequest;
import me.zhyd.oauth.utils.GlobalAuthUtils;
import me.zhyd.oauth.utils.HttpUtils;
import me.zhyd.oauth.utils.UrlBuilder;

public class AuthTwitterRequest
extends AuthDefaultRequest {
    private static final String PREAMBLE = "OAuth";

    public AuthTwitterRequest(AuthConfig config) {
        super(config, AuthDefaultSource.TWITTER);
    }

    public AuthTwitterRequest(AuthConfig config, AuthStateCache authStateCache) {
        super(config, AuthDefaultSource.TWITTER, authStateCache);
    }

    @Override
    public String authorize(String state) {
        AuthToken token = this.getRequestToken();
        return UrlBuilder.fromBaseUrl(this.source.authorize()).queryParam("oauth_token", token.getOauthToken()).build();
    }

    public AuthToken getRequestToken() {
        String baseUrl = "https://api.twitter.com/oauth/request_token";
        Map<String, String> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_callback", this.config.getRedirectUri());
        oauthParams.put("oauth_signature", GlobalAuthUtils.generateTwitterSignature(oauthParams, "POST", baseUrl, this.config.getClientSecret(), null));
        String header = this.buildHeader(oauthParams);
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Authorization", header);
        httpHeader.add("User-Agent", "'JustAuth' HTTP Client Simple-Http");
        String requestToken = new HttpUtils(this.config.getHttpConfig()).post(baseUrl, null, httpHeader).getBody();
        Map res = MapUtil.parseStringToMap((String)requestToken, (boolean)false);
        return AuthToken.builder().oauthToken((String)res.get("oauth_token")).oauthTokenSecret((String)res.get("oauth_token_secret")).oauthCallbackConfirmed(Boolean.valueOf((String)res.get("oauth_callback_confirmed"))).build();
    }

    @Override
    public AuthToken getAccessToken(AuthCallback authCallback) {
        Map<String, String> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_token", authCallback.getOauth_token());
        oauthParams.put("oauth_verifier", authCallback.getOauth_verifier());
        oauthParams.put("oauth_signature", GlobalAuthUtils.generateTwitterSignature(oauthParams, "POST", this.source.accessToken(), this.config.getClientSecret(), authCallback.getOauth_token()));
        String header = this.buildHeader(oauthParams);
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Authorization", header);
        httpHeader.add("Content-Type", "application/x-www-form-urlencoded");
        HashMap<String, String> form = new HashMap<String, String>(3);
        form.put("oauth_verifier", authCallback.getOauth_verifier());
        String response = new HttpUtils(this.config.getHttpConfig()).post(this.source.accessToken(), form, httpHeader, false).getBody();
        Map requestToken = MapUtil.parseStringToMap((String)response, (boolean)false);
        return AuthToken.builder().oauthToken((String)requestToken.get("oauth_token")).oauthTokenSecret((String)requestToken.get("oauth_token_secret")).userId((String)requestToken.get("user_id")).screenName((String)requestToken.get("screen_name")).build();
    }

    @Override
    public AuthUser getUserInfo(AuthToken authToken) {
        HashMap<String, String> queryParams = new HashMap<String, String>(5);
        queryParams.put("include_entities", Boolean.toString(true));
        queryParams.put("include_email", Boolean.toString(true));
        Map<String, String> oauthParams = this.buildOauthParams();
        oauthParams.put("oauth_token", authToken.getOauthToken());
        HashMap<String, String> params = new HashMap<String, String>(oauthParams);
        params.putAll(queryParams);
        oauthParams.put("oauth_signature", GlobalAuthUtils.generateTwitterSignature(params, "GET", this.source.userInfo(), this.config.getClientSecret(), authToken.getOauthTokenSecret()));
        String header = this.buildHeader(oauthParams);
        HttpHeader httpHeader = new HttpHeader();
        httpHeader.add("Authorization", header);
        String response = new HttpUtils(this.config.getHttpConfig()).get(this.userInfoUrl(authToken), null, httpHeader, false).getBody();
        JSONObject userInfo = JSONObject.parseObject((String)response);
        return AuthUser.builder().rawUserInfo(userInfo).uuid(userInfo.getString("id_str")).username(userInfo.getString("screen_name")).nickname(userInfo.getString("name")).remark(userInfo.getString("description")).avatar(userInfo.getString("profile_image_url_https")).blog(userInfo.getString("url")).location(userInfo.getString("location")).avatar(userInfo.getString("profile_image_url")).email(userInfo.getString("email")).source(this.source.toString()).token(authToken).build();
    }

    @Override
    protected String userInfoUrl(AuthToken authToken) {
        return UrlBuilder.fromBaseUrl(this.source.userInfo()).queryParam("include_entities", true).queryParam("include_email", true).build();
    }

    private Map<String, String> buildOauthParams() {
        HashMap<String, String> params = new HashMap<String, String>(12);
        params.put("oauth_consumer_key", this.config.getClientId());
        params.put("oauth_nonce", GlobalAuthUtils.generateNonce(32));
        params.put("oauth_signature_method", "HMAC-SHA1");
        params.put("oauth_timestamp", GlobalAuthUtils.getTimestamp());
        params.put("oauth_version", "1.0");
        return params;
    }

    private String buildHeader(Map<String, String> oauthParams) {
        StringBuilder sb = new StringBuilder("OAuth ");
        for (Map.Entry<String, String> param : oauthParams.entrySet()) {
            sb.append(param.getKey()).append("=\"").append(GlobalAuthUtils.urlEncode(param.getValue())).append('\"').append(", ");
        }
        return sb.deleteCharAt(sb.length() - 2).toString();
    }
}

