/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.utils;

import java.nio.charset.StandardCharsets;
import me.zhyd.oauth.utils.Base64Utils;
import me.zhyd.oauth.utils.RandomUtil;
import me.zhyd.oauth.utils.Sha256;

public class PkceUtil {
    public static String generateCodeVerifier() {
        String randomStr = RandomUtil.randomString(50);
        return Base64Utils.encodeUrlSafe(randomStr);
    }

    public static String generateCodeChallenge(String codeChallengeMethod, String codeVerifier) {
        if ("S256".equalsIgnoreCase(codeChallengeMethod)) {
            return PkceUtil.newStringUsAscii(Base64Utils.encodeUrlSafe(Sha256.digest(codeVerifier), true));
        }
        return codeVerifier;
    }

    public static String newStringUsAscii(byte[] bytes) {
        return new String(bytes, StandardCharsets.US_ASCII);
    }
}

