/*
 * Decompiled with CFR 0.152.
 */
package me.zhyd.oauth.utils;

import me.zhyd.oauth.utils.Base64Utils;

public class TokenUtils {
    private static final String BEARER = "Bearer ";
    private static final String BASIC = "Basic ";
    private static final String OAUTH2 = "OAuth2 ";
    private static final String TOKEN = "token ";

    private static String create(String prefix, String accessToken) {
        return prefix + accessToken;
    }

    public static String basic(String accessToken) {
        return TokenUtils.create(BASIC, accessToken);
    }

    public static String basic(String clientId, String clientSecret) {
        String token = Base64Utils.encode((clientId + ":" + clientSecret).getBytes());
        return TokenUtils.basic(token);
    }

    public static String bearer(String accessToken) {
        return TokenUtils.create(BEARER, accessToken);
    }

    public static String oauth2(String accessToken) {
        return TokenUtils.create(OAUTH2, accessToken);
    }

    public static String token(String accessToken) {
        return TokenUtils.create(TOKEN, accessToken);
    }
}

