/*
 * Copyright (c) 2020-2030 郑庚伟 ZHENGGENGWEI (码匠君) (herodotus@aliyun.com & www.herodotus.cn)
 *
 * Dante Engine licensed under the GNU LESSER GENERAL PUBLIC LICENSE 3.0;
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * <http://www.gnu.org/licenses/lgpl-3.0.html>
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package cn.herodotus.stirrup.core.definition.constants;

/**
 * @author gengwei.zheng
 */
public interface SymbolConstants {

    String AMPERSAND = "&";

    String AMPERSAND_ENCODED = "&amp;";

    String APOSTROPHE = "'";

    String APOSTROPHE_AND_COMMA = "',";

    String APOSTROPHE_AND_COMMA_AND_APOSTROPHE = "','";

    String AT = "@";

    String BACK_SLASH = "\\";

    String BETWEEN = "BETWEEN";

    String BLANK = "";

    String CDATA_OPEN = "<![CDATA[";

    String CDATA_CLOSE = "]]>";

    String CLOSE_BRACKET = "]";

    String CLOSE_CURLY_BRACE = "}";

    String CLOSE_PARENTHESIS = ")";

    String COLON = ":";

    String COMMA = ",";

    String COMMA_AND_APOSTROPHE = ",'";

    String COMMA_AND_SPACE = ", ";
    String SEMICOLON_AND_SPACE = "; ";

    String DASH = "-";

    String DOUBLE_APOSTROPHE = "''";

    String DOUBLE_CLOSE_BRACKET = "]]";

    String DOUBLE_OPEN_BRACKET = "[[";

    String DOUBLE_SLASH = "//";

    String EQUAL = "=";

    String GREATER_THAN = ">";

    String GREATER_THAN_OR_EQUAL = ">=";

    String FORWARD_SLASH = "/";

    String FOUR_SPACES = "    ";

    String FINISH_LEFT_ANGLE = "</";

    String FINISH_RIGHT_ANGLE = "/>";

    String GBK = "GBK";

    String IS_NOT_NULL = "IS NOT NULL";

    String IS_NULL = "IS NULL";

    String IN = "IN";

    String LEFT_ANGLE = "<";

    String LESS_THAN = "<";

    String LESS_THAN_OR_EQUAL = "<=";

    String LIKE = "LIKE";

    String MINUS = "-";

    String NBSP = "&nbsp;";

    String NEW_LINE = "\n";

    String NOT_EQUAL = "!=";

    String DB_NOT_EQUAL = "<>";

    String NOT_LIKE = "NOT LIKE";

    String NULL = "null";

    String OPEN_BRACKET = "[";

    String OPEN_CURLY_BRACE = "{";

    String OPEN_PARENTHESIS = "(";

    String PERCENT = "%";

    String PERIOD = ".";

    String PIPE = "|";

    String PLUS = "+";

    String POUND = "#";

    String QUESTION = "?";

    String QUOTE = "\"";

    String RETURN = "\r";

    String RETURN_NEW_LINE = "\r\n";

    String RIGHT_ANGLE = ">";

    String SEMICOLON = ";";

    String SLASH = FORWARD_SLASH;

    String SPACE = " ";

    String STAR = "*";

    String TAB = "\t";

    String TILDE = "~";

    String UNDERLINE = "_";

    String ZERO = "0";

    String SUFFIX_EXCEL_2003 = ".xls";

    String SUFFIX_EXCEL_2007 = ".xlsx";

    String SUFFIX_JPEG = ".jpg";

    String SUFFIX_XML = ".xml";

    String SUFFIX_PDF = ".pdf";

    String SUFFIX_ZIP = ".zip";

    String SUFFIX_DOC = ".doc";

    String SUFFIX_DOCX = ".docx";

    String SUFFIX_PPT = ".ppt";

    String SUFFIX_PPTX = ".pptx";

    String SUFFIX_EXCEL = ".xls";

    String SUFFIX_EXCELX = ".xlsx";

    String SUFFIX_SWF = ".swf";

    String SUFFIX_PROPERTIES = ".properties";

    String SUFFIX_YML = ".yml";

    String SUFFIX_YAML = ".yaml";

    String SUFFIX_JSON = ".json";

    String XML_DECLARATION = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
}
