/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.definition.domain;

import cn.herodotus.stirrup.core.definition.constants.ErrorCodes;
import cn.herodotus.stirrup.core.definition.domain.Feedback;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class ErrorCodeMapper {
    private static volatile ErrorCodeMapper instance;
    private final Map<Feedback, Integer> dictionary = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.OK, ErrorCodes.OK.getSequence());
            this.put(ErrorCodes.NO_CONTENT, ErrorCodes.NO_CONTENT.getSequence());
        }
    };

    private ErrorCodeMapper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ErrorCodeMapper getInstance() {
        if (!ObjectUtils.isEmpty((Object)instance)) return instance;
        Class<ErrorCodeMapper> clazz = ErrorCodeMapper.class;
        synchronized (ErrorCodeMapper.class) {
            if (!ObjectUtils.isEmpty((Object)instance)) return instance;
            instance = new ErrorCodeMapper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private Integer getErrorCode(Feedback feedback) {
        return this.dictionary.get(feedback);
    }

    public void append(Map<Feedback, Integer> indexes) {
        if (MapUtils.isNotEmpty(indexes)) {
            this.dictionary.putAll(indexes);
        }
    }

    public static Integer get(Feedback feedback) {
        return ErrorCodeMapper.getInstance().getErrorCode(feedback);
    }
}

