/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.definition.domain;

import com.google.common.base.Objects;
import java.io.Serializable;
import org.dromara.hutool.core.lang.Assert;

public class Feedback
implements Serializable {
    private static final int IS_NOT_CUSTOMIZED = 0;
    private final String message;
    private final int status;
    private final int custom;

    public Feedback(String message, int status) {
        this(message, status, 0);
    }

    public Feedback(String message, int status, int custom) {
        Assert.checkBetween((int)custom, (int)0, (int)9);
        this.message = message;
        this.status = status;
        this.custom = custom;
    }

    public String getMessage() {
        return this.message;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isCustom() {
        return this.custom != 0;
    }

    public int getCustom() {
        return this.custom;
    }

    public int getSequence() {
        if (this.isCustom()) {
            return this.custom * 10000;
        }
        return this.status * 100;
    }

    public int getSequence(int index) {
        return this.getSequence() + index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Feedback feedback = (Feedback)o;
        return Objects.equal((Object)this.message, (Object)feedback.message);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.message});
    }
}

