/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.definition.support;

import cn.herodotus.stirrup.core.definition.domain.Pool;
import cn.herodotus.stirrup.core.definition.exception.BorrowObjectFromPoolErrorException;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractObjectPool<T> {
    private static final Logger log = LoggerFactory.getLogger(AbstractObjectPool.class);
    private final GenericObjectPool<T> genericObjectPool;

    protected AbstractObjectPool(@Nonnull PooledObjectFactory<T> pooledObjectFactory, @Nonnull Pool pool) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        config.setMaxTotal(pool.getMaxTotal().intValue());
        config.setMaxIdle(pool.getMaxIdle().intValue());
        config.setMinIdle(pool.getMinIdle().intValue());
        config.setMaxWait(pool.getMaxWait());
        config.setMinEvictableIdleDuration(pool.getMinEvictableIdleDuration());
        config.setSoftMinEvictableIdleDuration(pool.getSoftMinEvictableIdleDuration());
        config.setLifo(pool.getLifo().booleanValue());
        config.setBlockWhenExhausted(pool.getBlockWhenExhausted().booleanValue());
        this.genericObjectPool = new GenericObjectPool(pooledObjectFactory, config);
    }

    public T get() {
        try {
            Object object = this.genericObjectPool.borrowObject();
            log.debug("[Herodotus] |- Fetch object from object pool.");
            return (T)object;
        }
        catch (Exception e) {
            log.error("[Herodotus] |- Can not fetch object from pool.", (Throwable)e);
            throw new BorrowObjectFromPoolErrorException("Can not fetch object from pool.");
        }
    }

    public void close(T client) {
        if (ObjectUtils.isNotEmpty(client)) {
            log.debug("[Herodotus] |- Close object in pool.");
            this.genericObjectPool.returnObject(client);
        }
    }
}

