/*
 * Decompiled with CFR 0.152.
 */
package cn.herodotus.stirrup.core.definition.support;

import cn.herodotus.stirrup.core.definition.constants.ErrorCodes;
import cn.herodotus.stirrup.core.definition.domain.ErrorCodeMapper;
import cn.herodotus.stirrup.core.definition.domain.Feedback;
import cn.herodotus.stirrup.core.definition.feedback.CustomizeFeedback;
import cn.herodotus.stirrup.core.definition.feedback.ForbiddenFeedback;
import cn.herodotus.stirrup.core.definition.feedback.InternalServerErrorFeedback;
import cn.herodotus.stirrup.core.definition.feedback.MethodNotAllowedFeedback;
import cn.herodotus.stirrup.core.definition.feedback.NotAcceptableFeedback;
import cn.herodotus.stirrup.core.definition.feedback.NotImplementedFeedback;
import cn.herodotus.stirrup.core.definition.feedback.PreconditionFailedFeedback;
import cn.herodotus.stirrup.core.definition.feedback.ServiceUnavailableFeedback;
import cn.herodotus.stirrup.core.definition.feedback.UnauthorizedFeedback;
import cn.herodotus.stirrup.core.definition.feedback.UnsupportedMediaTypeFeedback;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;

public class ErrorCodeMapperBuilder {
    private final Map<Feedback, Integer> unauthorizedConfigs = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.UNAUTHORIZED, ErrorCodes.UNAUTHORIZED.getSequence());
        }
    };
    private final Map<Feedback, Integer> forbiddenConfigs = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.FORBIDDEN, ErrorCodes.FORBIDDEN.getSequence());
        }
    };
    private final Map<Feedback, Integer> methodNotAllowedConfigs = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.METHOD_NOT_ALLOWED, ErrorCodes.METHOD_NOT_ALLOWED.getSequence());
        }
    };
    private final Map<Feedback, Integer> notAcceptableConfigs = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.NOT_ACCEPTABLE, ErrorCodes.NOT_ACCEPTABLE.getSequence());
        }
    };
    private final Map<Feedback, Integer> preconditionFailedConfigs = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.PRECONDITION_FAILED, ErrorCodes.PRECONDITION_FAILED.getSequence());
        }
    };
    private final Map<Feedback, Integer> unsupportedMediaTypeConfigs = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.PRECONDITION_FAILED, ErrorCodes.PRECONDITION_FAILED.getSequence());
        }
    };
    private final Map<Feedback, Integer> internalServerErrorConfigs = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.INTERNAL_SERVER_ERROR, ErrorCodes.INTERNAL_SERVER_ERROR.getSequence());
        }
    };
    private final Map<Feedback, Integer> notImplementedConfigs = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.NOT_IMPLEMENTED, ErrorCodes.NOT_IMPLEMENTED.getSequence());
        }
    };
    private final Map<Feedback, Integer> serviceUnavailableConfigs = new LinkedHashMap<Feedback, Integer>(){
        {
            this.put(ErrorCodes.SERVICE_UNAVAILABLE, ErrorCodes.SERVICE_UNAVAILABLE.getSequence());
            this.put(ErrorCodes.OPEN_API_REQUEST_FAILURE, ErrorCodes.OPEN_API_REQUEST_FAILURE.getSequence());
        }
    };
    private final Map<Integer, Map<Feedback, Integer>> customizeConfigs = new LinkedHashMap<Integer, Map<Feedback, Integer>>();

    private ErrorCodeMapperBuilder create(Map<Feedback, Integer> container, Feedback ... items) {
        for (Feedback item : items) {
            container.put(item, item.getSequence(container.size()));
        }
        return this;
    }

    public ErrorCodeMapperBuilder customize(CustomizeFeedback ... items) {
        for (CustomizeFeedback item : items) {
            if (!item.isCustom()) continue;
            Map<Feedback, Integer> config = this.customizeConfigs.get(item.getCustom());
            if (MapUtils.isEmpty(config)) {
                config = new LinkedHashMap<Feedback, Integer>();
            }
            config.put(item, item.getSequence(config.size()));
            this.customizeConfigs.put(item.getCustom(), config);
        }
        return this;
    }

    public ErrorCodeMapperBuilder unauthorized(UnauthorizedFeedback ... items) {
        return this.create(this.unauthorizedConfigs, items);
    }

    public ErrorCodeMapperBuilder forbidden(ForbiddenFeedback ... items) {
        return this.create(this.forbiddenConfigs, items);
    }

    public ErrorCodeMapperBuilder methodNotAllowed(MethodNotAllowedFeedback ... items) {
        return this.create(this.methodNotAllowedConfigs, items);
    }

    public ErrorCodeMapperBuilder notAcceptable(NotAcceptableFeedback ... items) {
        return this.create(this.notAcceptableConfigs, items);
    }

    public ErrorCodeMapperBuilder preconditionFailed(PreconditionFailedFeedback ... items) {
        return this.create(this.preconditionFailedConfigs, items);
    }

    public ErrorCodeMapperBuilder unsupportedMediaType(UnsupportedMediaTypeFeedback ... items) {
        return this.create(this.unsupportedMediaTypeConfigs, items);
    }

    public ErrorCodeMapperBuilder internalServerError(InternalServerErrorFeedback ... items) {
        return this.create(this.internalServerErrorConfigs, items);
    }

    public ErrorCodeMapperBuilder notImplemented(NotImplementedFeedback ... items) {
        return this.create(this.notImplementedConfigs, items);
    }

    public ErrorCodeMapperBuilder serviceUnavailable(ServiceUnavailableFeedback ... items) {
        return this.create(this.serviceUnavailableConfigs, items);
    }

    public ErrorCodeMapper build() {
        ErrorCodeMapper errorCodeMapper = ErrorCodeMapper.getInstance();
        errorCodeMapper.append(this.unauthorizedConfigs);
        errorCodeMapper.append(this.forbiddenConfigs);
        errorCodeMapper.append(this.methodNotAllowedConfigs);
        errorCodeMapper.append(this.notAcceptableConfigs);
        errorCodeMapper.append(this.preconditionFailedConfigs);
        errorCodeMapper.append(this.unsupportedMediaTypeConfigs);
        errorCodeMapper.append(this.internalServerErrorConfigs);
        errorCodeMapper.append(this.notImplementedConfigs);
        errorCodeMapper.append(this.serviceUnavailableConfigs);
        this.customizeConfigs.forEach((key, feedbacks) -> errorCodeMapper.append((Map<Feedback, Integer>)feedbacks));
        return errorCodeMapper;
    }
}

